/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.inject;

import com.google.common.base.Preconditions;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.InjectionContext;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.SpecifiedInjector;
import dev.derklaro.aerogel.binding.BindingConstructor;
import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.driver.inject.DefaultInjectionLayer;
import eu.cloudnetservice.driver.inject.InjectionLayerProvider;
import eu.cloudnetservice.driver.inject.UncloseableInjectionLayer;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;
import org.jetbrains.annotations.UnknownNullability;

public sealed interface InjectionLayer<I extends Injector>
extends Named,
AutoCloseable
permits DefaultInjectionLayer, UncloseableInjectionLayer {
    public static final String AUTO_CONFIGURE_FILE_NAME_FORMAT = "autoconfigure/%s.aero";

    @NonNull
    public static InjectionLayer<Injector> boot() {
        return InjectionLayerProvider.boot();
    }

    @NonNull
    public static InjectionLayer<Injector> ext() {
        return InjectionLayerProvider.ext();
    }

    @NonNull
    public static InjectionLayer<Injector> fresh(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return InjectionLayerProvider.fresh(name);
    }

    @NonNull
    public static InjectionLayer<Injector> child(@NonNull InjectionLayer<Injector> parent, @NonNull String name) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return InjectionLayerProvider.child(parent, name);
    }

    @NonNull
    public static InjectionLayer<SpecifiedInjector> specifiedChild(@NonNull InjectionLayer<? extends Injector> parent, @NonNull String name, @NonNull BiConsumer<InjectionLayer<SpecifiedInjector>, SpecifiedInjector> configurator) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (configurator == null) {
            throw new NullPointerException("configurator is marked non-null but is null");
        }
        Preconditions.checkArgument(parent != InjectionLayer.boot(), "Parent of a specified layer cannot be the boot layer");
        return InjectionLayerProvider.specifiedChild(parent, name, configurator);
    }

    @NonNull
    public static InjectionLayer<?> findLayerOf(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return InjectionLayer.findLayerOf(object, InjectionLayer.ext());
    }

    @NonNull
    public static InjectionLayer<?> findLayerOf(@NonNull Object object, @NonNull InjectionLayer<?> def) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (def == null) {
            throw new NullPointerException("def is marked non-null but is null");
        }
        return InjectionLayerProvider.findLayerOf(object, def);
    }

    @Override
    @NonNull
    public String name();

    @NonNull
    public I injector();

    public <T> @UnknownNullability T instance(@NonNull Class<T> var1);

    public <T> @UnknownNullability T instance(@NonNull Element var1);

    public <T> @UnknownNullability T instance(@NonNull Class<T> var1, @NonNull Consumer<InjectionContext.Builder> var2);

    public void install(@NonNull BindingConstructor var1);

    public void installAutoConfigureBindings(@NonNull ClassLoader var1, @NonNull String var2);

    @NonNull
    public InjectionLayer<I> asUncloseable();

    @NonNull
    public InjectionLayer<I> register(Object ... var1);

    @Override
    public void close();
}

