/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.inject;

import com.google.common.base.Preconditions;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.binding.BindingBuilder;
import dev.derklaro.aerogel.binding.BindingConstructor;
import dev.derklaro.aerogel.internal.util.ElementHelper;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class InjectUtil {
    private static final Object[] EMPTY_INSTANCE_ARRAY = new Object[0];
    private static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];

    private InjectUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static Element[] buildElementsForParameters(@NonNull Parameter[] parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        return InjectUtil.buildElementsForParameters(parameters, 0);
    }

    @NonNull
    public static Element[] buildElementsForParameters(@NonNull Parameter[] parameters, int offset) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (parameters.length <= offset) {
            return EMPTY_ELEMENT_ARRAY;
        }
        Parameter[] params = Arrays.copyOfRange(parameters, offset, parameters.length);
        Element[] elements = new Element[params.length];
        for (int i = 0; i < params.length; ++i) {
            Parameter parameter = params[i];
            elements[i] = ElementHelper.buildElement(parameter, (Annotation[][])new Annotation[][]{parameter.getDeclaredAnnotations()});
        }
        return elements;
    }

    @NonNull
    public static Object[] findAllInstances(@NonNull InjectionLayer<?> layer, @NonNull Element[] elements) {
        if (layer == null) {
            throw new NullPointerException("layer is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        return InjectUtil.findAllInstances(layer, elements, 0);
    }

    @NonNull
    public static Object[] findAllInstances(@NonNull InjectionLayer<?> layer, @NonNull Element[] elements, int offset) {
        if (layer == null) {
            throw new NullPointerException("layer is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        Preconditions.checkArgument(offset >= 0, "offset must be >= 0");
        if (elements.length == 0 && offset == 0) {
            return EMPTY_INSTANCE_ARRAY;
        }
        if (elements.length == 0) {
            return new Object[offset];
        }
        Object[] instances = new Object[elements.length + offset];
        for (int i = 0; i < elements.length; ++i) {
            instances[i + offset] = layer.instance(elements[i]);
        }
        return instances;
    }

    @NonNull
    public static BindingConstructor createFixedBinding(@NonNull Object value, Type ... types) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (types == null) {
            throw new NullPointerException("types is marked non-null but is null");
        }
        Objects.checkIndex(0, types.length);
        if (types.length == 1) {
            return BindingBuilder.create().bindFully(types[0]).toInstance(value);
        }
        return BindingBuilder.create().bindAllFully(types).toInstance(value);
    }
}

