/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.property;

import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DocProperty;
import eu.cloudnetservice.driver.document.property.ReadOnlyDocProperty;
import eu.cloudnetservice.driver.document.property.RewritingDocProperty;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

record DefaultingDocProperty<E>(@NonNull DocProperty<E> downstream, @Nullable E def) implements DocProperty<E>
{
    @Generated
    public DefaultingDocProperty(@NonNull DocProperty<E> downstream, @Nullable E def) {
        if (downstream == null) {
            throw new NullPointerException("downstream is marked non-null but is null");
        }
    }

    @Override
    @NonNull
    public String key() {
        return this.downstream.key();
    }

    @Override
    public boolean readOnly() {
        return false;
    }

    @Override
    @NonNull
    public DocProperty<E> asReadOnly() {
        return new ReadOnlyDocProperty(this);
    }

    @Override
    @NonNull
    public DocProperty<E> withDefault(@Nullable E def) {
        return Objects.equals(this.def, def) ? this : new DefaultingDocProperty<E>(this.downstream, def);
    }

    @Override
    @NonNull
    public <V> DocProperty<V> withReadRewrite(@NonNull Function<E, V> rewriteFunction) {
        if (rewriteFunction == null) {
            throw new NullPointerException("rewriteFunction is marked non-null but is null");
        }
        return this.withReadWriteRewrite(rewriteFunction, null);
    }

    @Override
    @NonNull
    public <V> DocProperty<V> withReadWriteRewrite(@NonNull Function<E, V> readRewriteFunction, @Nullable Function<V, E> writeRewriteFunction) {
        if (readRewriteFunction == null) {
            throw new NullPointerException("readRewriteFunction is marked non-null but is null");
        }
        RewritingDocProperty<E, V> rewritingProperty = new RewritingDocProperty<E, V>(this, readRewriteFunction, writeRewriteFunction);
        return writeRewriteFunction == null ? rewritingProperty.asReadOnly() : rewritingProperty;
    }

    @Override
    @Nullable
    public E readFrom(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        E downstreamValue = this.downstream.readFrom(document);
        return downstreamValue == null ? this.def : downstreamValue;
    }

    @Override
    @NonNull
    public DocProperty<E> writeTo(@NonNull Document.Mutable document, @Nullable E value) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.downstream.writeTo(document, value == null ? this.def : value);
        return this;
    }
}

