/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson.send;

import com.google.gson.JsonArray;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import eu.cloudnetservice.driver.document.gson.send.GsonArrayVisitor;
import eu.cloudnetservice.driver.document.gson.send.GsonPrimitiveConverter;
import eu.cloudnetservice.driver.document.send.ElementVisitor;
import eu.cloudnetservice.driver.document.send.element.ArrayElement;
import eu.cloudnetservice.driver.document.send.element.NullElement;
import eu.cloudnetservice.driver.document.send.element.ObjectElement;
import eu.cloudnetservice.driver.document.send.element.PrimitiveElement;
import lombok.Generated;
import lombok.NonNull;

record GsonObjectVisitor(@NonNull JsonObject targetObject) implements ElementVisitor
{
    @Generated
    public GsonObjectVisitor(@NonNull JsonObject targetObject) {
        if (targetObject == null) {
            throw new NullPointerException("targetObject is marked non-null but is null");
        }
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public void visitNull(@NonNull NullElement entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.targetObject.add(entry.key(), JsonNull.INSTANCE);
    }

    @Override
    public void visitPrimitive(@NonNull PrimitiveElement entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        JsonPrimitive primitive = GsonPrimitiveConverter.wrapAsPrimitive(entry.innerValue());
        this.targetObject.add(entry.key(), primitive);
    }

    @Override
    @NonNull
    public ElementVisitor visitArray(@NonNull ArrayElement entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        JsonArray array = new JsonArray();
        this.targetObject.add(entry.key(), array);
        return new GsonArrayVisitor(array);
    }

    @Override
    @NonNull
    public ElementVisitor visitObject(@NonNull ObjectElement entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        JsonObject object = new JsonObject();
        this.targetObject.add(entry.key(), object);
        return new GsonObjectVisitor(object);
    }
}

