/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson.send;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.DocumentFactory;
import eu.cloudnetservice.driver.document.gson.send.GsonPrimitiveConverter;
import eu.cloudnetservice.driver.document.send.DocumentSend;
import eu.cloudnetservice.driver.document.send.element.ArrayElement;
import eu.cloudnetservice.driver.document.send.element.NullElement;
import eu.cloudnetservice.driver.document.send.element.ObjectElement;
import eu.cloudnetservice.driver.document.send.element.PrimitiveElement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public record GsonDocumentSend(@NonNull ObjectElement rootElement) implements DocumentSend
{
    @Generated
    public GsonDocumentSend(@NonNull ObjectElement rootElement) {
        if (rootElement == null) {
            throw new NullPointerException("rootElement is marked non-null but is null");
        }
    }

    @NonNull
    public static DocumentSend fromJsonObject(@NonNull JsonObject object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        ObjectElement serializedObject = GsonDocumentSend.serializeObject("", object);
        return new GsonDocumentSend(serializedObject);
    }

    @NonNull
    private static ObjectElement serializeObject(@NonNull String key, @NonNull JsonObject object) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        LinkedList<Record> elements = new LinkedList<Record>();
        ImmutableSet<Map.Entry<String, JsonElement>> entries = ImmutableSet.copyOf(object.entrySet());
        for (Map.Entry entry : entries) {
            JsonElement element = (JsonElement)entry.getValue();
            if (element.isJsonNull()) {
                elements.add(new NullElement((String)entry.getKey()));
                continue;
            }
            if (element.isJsonPrimitive()) {
                PrimitiveElement wrappedPrimitive = GsonPrimitiveConverter.unwrapJsonPrimitive((String)entry.getKey(), element.getAsJsonPrimitive());
                elements.add(wrappedPrimitive);
                continue;
            }
            if (element.isJsonObject()) {
                ObjectElement wrappedObject = GsonDocumentSend.serializeObject((String)entry.getKey(), element.getAsJsonObject());
                elements.add(wrappedObject);
                continue;
            }
            if (element.isJsonArray()) {
                ArrayElement wrappedArray = GsonDocumentSend.serializeArray((String)entry.getKey(), element.getAsJsonArray());
                elements.add(wrappedArray);
                continue;
            }
            throw new IllegalArgumentException("Don't known how to handle json element " + element.getClass().getName());
        }
        Collection unmodifiableElements = Collections.unmodifiableCollection(elements);
        return new ObjectElement(key, unmodifiableElements);
    }

    @NonNull
    private static ArrayElement serializeArray(@NonNull String key, @NonNull JsonArray array) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        LinkedList<Record> elements = new LinkedList<Record>();
        ImmutableList<JsonElement> entries = ImmutableList.copyOf(array.asList());
        for (JsonElement element : entries) {
            if (element.isJsonNull()) {
                elements.add(new NullElement(""));
                continue;
            }
            if (element.isJsonPrimitive()) {
                PrimitiveElement wrappedPrimitive = GsonPrimitiveConverter.unwrapJsonPrimitive("", element.getAsJsonPrimitive());
                elements.add(wrappedPrimitive);
                continue;
            }
            if (element.isJsonObject()) {
                ObjectElement wrappedObject = GsonDocumentSend.serializeObject("", element.getAsJsonObject());
                elements.add(wrappedObject);
                continue;
            }
            if (element.isJsonArray()) {
                ArrayElement wrappedArray = GsonDocumentSend.serializeArray("", element.getAsJsonArray());
                elements.add(wrappedArray);
                continue;
            }
            throw new IllegalArgumentException("Don't known how to handle json element " + element.getClass().getName());
        }
        Collection unmodifiableElements = Collections.unmodifiableCollection(elements);
        return new ArrayElement(key, unmodifiableElements);
    }

    @Override
    @NonNull
    public Document.Mutable into(@NonNull DocumentFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        return factory.receive(this);
    }
}

