/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson.send;

import com.google.gson.JsonArray;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import eu.cloudnetservice.driver.document.gson.send.GsonObjectVisitor;
import eu.cloudnetservice.driver.document.gson.send.GsonPrimitiveConverter;
import eu.cloudnetservice.driver.document.send.ElementVisitor;
import eu.cloudnetservice.driver.document.send.element.ArrayElement;
import eu.cloudnetservice.driver.document.send.element.NullElement;
import eu.cloudnetservice.driver.document.send.element.ObjectElement;
import eu.cloudnetservice.driver.document.send.element.PrimitiveElement;
import lombok.Generated;
import lombok.NonNull;

record GsonArrayVisitor(@NonNull JsonArray targetArray) implements ElementVisitor
{
    @Generated
    public GsonArrayVisitor(@NonNull JsonArray targetArray) {
        if (targetArray == null) {
            throw new NullPointerException("targetArray is marked non-null but is null");
        }
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public void visitNull(@NonNull NullElement entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.targetArray.add(JsonNull.INSTANCE);
    }

    @Override
    public void visitPrimitive(@NonNull PrimitiveElement entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        JsonPrimitive primitive = GsonPrimitiveConverter.wrapAsPrimitive(entry.innerValue());
        this.targetArray.add(primitive);
    }

    @Override
    @NonNull
    public ElementVisitor visitArray(@NonNull ArrayElement entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        JsonArray array = new JsonArray();
        this.targetArray.add(array);
        return new GsonArrayVisitor(array);
    }

    @Override
    @NonNull
    public ElementVisitor visitObject(@NonNull ObjectElement entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        JsonObject object = new JsonObject();
        this.targetArray.add(object);
        return new GsonObjectVisitor(object);
    }
}

