/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class DurationTypeAdapter
extends TypeAdapter<Duration> {
    private final TypeAdapter<String> stringTypeAdapter;

    public DurationTypeAdapter(@NonNull Gson gsonInstance) {
        if (gsonInstance == null) {
            throw new NullPointerException("gsonInstance is marked non-null but is null");
        }
        this.stringTypeAdapter = gsonInstance.getAdapter(String.class);
    }

    @Override
    public void write(@NonNull JsonWriter out, @Nullable Duration value) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        this.stringTypeAdapter.write(out, value == null ? null : value.toString());
    }

    @Override
    @Nullable
    public Duration read(@NonNull JsonReader in) throws IOException {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        String duration = this.stringTypeAdapter.read(in);
        return duration == null ? null : Duration.parse(duration);
    }
}

