/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.gson.ImmutableGsonDocument;
import eu.cloudnetservice.driver.document.gson.MutableGsonDocument;
import java.io.IOException;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class DocumentTypeAdapter
extends TypeAdapter<Document> {
    private final TypeAdapter<JsonElement> jsonElementTypeAdapter;

    public DocumentTypeAdapter(@NonNull Gson gsonInstance) {
        if (gsonInstance == null) {
            throw new NullPointerException("gsonInstance is marked non-null but is null");
        }
        this.jsonElementTypeAdapter = gsonInstance.getAdapter(JsonElement.class);
    }

    @Override
    public void write(@NonNull JsonWriter out, @Nullable Document value) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        if (value == null) {
            out.beginObject().endObject();
            return;
        }
        if (value instanceof ImmutableGsonDocument) {
            ImmutableGsonDocument gsonDocument = (ImmutableGsonDocument)value;
            this.jsonElementTypeAdapter.write(out, gsonDocument.internalObject);
            return;
        }
        MutableGsonDocument targetDocument = new MutableGsonDocument();
        targetDocument.receive(value.send());
        this.jsonElementTypeAdapter.write(out, targetDocument.internalObject);
    }

    @Override
    @NonNull
    public Document read(@NonNull JsonReader in) throws IOException {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        JsonElement jsonElement = this.jsonElementTypeAdapter.read(in);
        if (jsonElement != null && jsonElement.isJsonObject()) {
            return new ImmutableGsonDocument(jsonElement.getAsJsonObject());
        }
        return new ImmutableGsonDocument();
    }
}

