/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.cluster;

import eu.cloudnetservice.driver.CloudNetVersion;
import eu.cloudnetservice.driver.cluster.NetworkClusterNode;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.driver.module.ModuleConfiguration;
import eu.cloudnetservice.driver.service.ProcessSnapshot;
import java.util.Collection;
import lombok.Generated;
import lombok.NonNull;

public class NodeInfoSnapshot
implements DefaultedDocPropertyHolder {
    protected final long creationTime;
    protected final long startupMillis;
    protected final int maxMemory;
    protected final int usedMemory;
    protected final int reservedMemory;
    protected final int currentServicesCount;
    protected final boolean drain;
    protected final NetworkClusterNode node;
    protected final CloudNetVersion version;
    protected final ProcessSnapshot processSnapshot;
    protected final double maxCPUUsageToStartServices;
    protected final Collection<ModuleConfiguration> modules;
    protected final Document properties;

    public NodeInfoSnapshot(long creationTime, long startupMillis, int maxMemory, int usedMemory, int reservedMemory, int currentServicesCount, boolean drain, @NonNull NetworkClusterNode node, @NonNull CloudNetVersion version, @NonNull ProcessSnapshot processSnapshot, double maxCPUUsageToStartServices, @NonNull Collection<ModuleConfiguration> modules, @NonNull Document properties) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (processSnapshot == null) {
            throw new NullPointerException("processSnapshot is marked non-null but is null");
        }
        if (modules == null) {
            throw new NullPointerException("modules is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.properties = properties;
        this.creationTime = creationTime;
        this.startupMillis = startupMillis;
        this.maxMemory = maxMemory;
        this.usedMemory = usedMemory;
        this.reservedMemory = reservedMemory;
        this.currentServicesCount = currentServicesCount;
        this.drain = drain;
        this.node = node;
        this.version = version;
        this.processSnapshot = processSnapshot;
        this.maxCPUUsageToStartServices = maxCPUUsageToStartServices;
        this.modules = modules;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public long startupMillis() {
        return this.startupMillis;
    }

    public int maxMemory() {
        return this.maxMemory;
    }

    public int usedMemory() {
        return this.usedMemory;
    }

    public int reservedMemory() {
        return this.reservedMemory;
    }

    public int currentServicesCount() {
        return this.currentServicesCount;
    }

    public boolean draining() {
        return this.drain;
    }

    @NonNull
    public NetworkClusterNode node() {
        return this.node;
    }

    @NonNull
    public CloudNetVersion version() {
        return this.version;
    }

    @NonNull
    public ProcessSnapshot processSnapshot() {
        return this.processSnapshot;
    }

    public double maxProcessorUsageToStartServices() {
        return this.maxCPUUsageToStartServices;
    }

    @NonNull
    public Collection<ModuleConfiguration> modules() {
        return this.modules;
    }

    public int memoryUsagePercentage() {
        return this.reservedMemory() * 100 / this.maxMemory();
    }

    @Override
    @NonNull
    public Document propertyHolder() {
        return this.properties;
    }

    @Generated
    public String toString() {
        return "NodeInfoSnapshot(creationTime=" + this.creationTime + ", startupMillis=" + this.startupMillis + ", maxMemory=" + this.maxMemory + ", usedMemory=" + this.usedMemory + ", reservedMemory=" + this.reservedMemory + ", currentServicesCount=" + this.currentServicesCount + ", drain=" + this.drain + ", node=" + String.valueOf(this.node) + ", version=" + String.valueOf(this.version) + ", processSnapshot=" + String.valueOf(this.processSnapshot) + ", maxCPUUsageToStartServices=" + this.maxCPUUsageToStartServices + ", modules=" + String.valueOf(this.modules) + ", properties=" + String.valueOf(this.properties) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeInfoSnapshot)) {
            return false;
        }
        NodeInfoSnapshot other = (NodeInfoSnapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.creationTime != other.creationTime) {
            return false;
        }
        if (this.startupMillis != other.startupMillis) {
            return false;
        }
        if (this.maxMemory != other.maxMemory) {
            return false;
        }
        if (this.usedMemory != other.usedMemory) {
            return false;
        }
        if (this.reservedMemory != other.reservedMemory) {
            return false;
        }
        if (this.currentServicesCount != other.currentServicesCount) {
            return false;
        }
        if (this.drain != other.drain) {
            return false;
        }
        if (Double.compare(this.maxCPUUsageToStartServices, other.maxCPUUsageToStartServices) != 0) {
            return false;
        }
        NetworkClusterNode this$node = this.node;
        NetworkClusterNode other$node = other.node;
        if (this$node == null ? other$node != null : !((Object)this$node).equals(other$node)) {
            return false;
        }
        CloudNetVersion this$version = this.version;
        CloudNetVersion other$version = other.version;
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        ProcessSnapshot this$processSnapshot = this.processSnapshot;
        ProcessSnapshot other$processSnapshot = other.processSnapshot;
        if (this$processSnapshot == null ? other$processSnapshot != null : !((Object)this$processSnapshot).equals(other$processSnapshot)) {
            return false;
        }
        Collection<ModuleConfiguration> this$modules = this.modules;
        Collection<ModuleConfiguration> other$modules = other.modules;
        if (this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules)) {
            return false;
        }
        Document this$properties = this.properties;
        Document other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NodeInfoSnapshot;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $creationTime = this.creationTime;
        result = result * 59 + (int)($creationTime >>> 32 ^ $creationTime);
        long $startupMillis = this.startupMillis;
        result = result * 59 + (int)($startupMillis >>> 32 ^ $startupMillis);
        result = result * 59 + this.maxMemory;
        result = result * 59 + this.usedMemory;
        result = result * 59 + this.reservedMemory;
        result = result * 59 + this.currentServicesCount;
        result = result * 59 + (this.drain ? 79 : 97);
        long $maxCPUUsageToStartServices = Double.doubleToLongBits(this.maxCPUUsageToStartServices);
        result = result * 59 + (int)($maxCPUUsageToStartServices >>> 32 ^ $maxCPUUsageToStartServices);
        NetworkClusterNode $node = this.node;
        result = result * 59 + ($node == null ? 43 : ((Object)$node).hashCode());
        CloudNetVersion $version = this.version;
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        ProcessSnapshot $processSnapshot = this.processSnapshot;
        result = result * 59 + ($processSnapshot == null ? 43 : ((Object)$processSnapshot).hashCode());
        Collection<ModuleConfiguration> $modules = this.modules;
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        Document $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }
}

