/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;

public record CloudNetVersion(int major, int minor, int patch, @NonNull String revision, @NonNull String versionType, @NonNull String versionTitle) {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+).(\\d+).(\\d+)(.*)");

    @Generated
    public CloudNetVersion(int major, int minor, int patch, @NonNull String revision, @NonNull String versionType, @NonNull String versionTitle) {
        if (revision == null) {
            throw new NullPointerException("revision is marked non-null but is null");
        }
        if (versionType == null) {
            throw new NullPointerException("versionType is marked non-null but is null");
        }
        if (versionTitle == null) {
            throw new NullPointerException("versionTitle is marked non-null but is null");
        }
    }

    @NonNull
    public static CloudNetVersion fromPackage(@NonNull Package source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        String title = source.getImplementationTitle();
        Matcher matcher = VERSION_PATTERN.matcher(source.getImplementationVersion());
        if (matcher.matches()) {
            String extraInformation;
            int lastSplit;
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int patch = Integer.parseInt(matcher.group(3));
            if (matcher.groupCount() > 3 && (lastSplit = (extraInformation = matcher.group(4)).lastIndexOf(45)) != -1) {
                String revision = extraInformation.substring(lastSplit + 1);
                String versionType = lastSplit == 0 ? "RELEASE" : extraInformation.substring(1, lastSplit);
                return new CloudNetVersion(major, minor, patch, revision, versionType, title);
            }
            return new CloudNetVersion(major, minor, patch, "", "custom", title);
        }
        throw new IllegalArgumentException("Unable to determine version from " + source.getImplementationVersion());
    }

    @Override
    @NonNull
    public String toString() {
        String toString = "CloudNet " + this.versionTitle + " " + this.major + "." + this.minor + "." + this.patch + "-" + this.versionType;
        if (!this.revision.isEmpty()) {
            toString = toString + " " + this.revision;
        }
        return toString;
    }
}

