/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.resource;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import lombok.NonNull;

public final class ResourceResolver {
    private ResourceResolver() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static URI resolveCodeSourceOfClass(@NonNull Class<?> caller) {
        String expectedUrlSuffix;
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        try {
            URL codeLocation;
            CodeSource classCodeSource = caller.getProtectionDomain().getCodeSource();
            if (classCodeSource != null && (codeLocation = classCodeSource.getLocation()) != null) {
                return codeLocation.toURI();
            }
        }
        catch (URISyntaxException classCodeSource) {
            // empty catch block
        }
        URL callingClassResource = caller.getResource(caller.getSimpleName() + ".class");
        if (callingClassResource == null) {
            throw ResourceResolver.resolveError(caller, "missing possibility to resolve class url");
        }
        String fullResourceUrl = callingClassResource.toExternalForm();
        if (!fullResourceUrl.endsWith(expectedUrlSuffix = caller.getCanonicalName().replace('.', '/') + ".class")) {
            throw ResourceResolver.resolveError(caller, "unexpected suffix on url " + fullResourceUrl + " (expected: " + expectedUrlSuffix + ")");
        }
        String strippedUrl = fullResourceUrl.substring(0, fullResourceUrl.length() - expectedUrlSuffix.length());
        if (strippedUrl.startsWith("jar:")) {
            strippedUrl = strippedUrl.substring(4);
        }
        if (strippedUrl.endsWith("!/")) {
            strippedUrl = strippedUrl.substring(0, strippedUrl.length() - 2);
        }
        return URI.create(strippedUrl);
    }

    @NonNull
    private static IllegalStateException resolveError(@NonNull Class<?> caller, @NonNull String reason) {
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        return new IllegalStateException("Unable to resolve uri of class " + String.valueOf(caller) + " due to " + reason);
    }
}

