/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.io;

import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.common.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class ZipUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipUtil.class);
    private static final boolean IS_WINDOWS = StringUtil.toLower(System.getProperty("os.name")).contains("windows");

    private ZipUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static InputStream zipToStream(@NonNull Path directory) {
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        return ZipUtil.zipToStream(directory, null);
    }

    @NonNull
    public static InputStream zipToStream(@NonNull Path directory, @Nullable Predicate<Path> fileFilter) {
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        Path target = FileUtil.createTempFile();
        ZipUtil.zipToFile(directory, target, path -> !target.equals(path) && (fileFilter == null || fileFilter.test((Path)path)));
        try {
            return Files.newInputStream(target, StandardOpenOption.DELETE_ON_CLOSE, LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException exception) {
            throw new IllegalStateException("Unable to open input stream to zip file " + String.valueOf(target), exception);
        }
    }

    @Nullable
    public static Path zipToFile(@NonNull Path dir, @NonNull Path target) {
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return ZipUtil.zipToFile(dir, target, null);
    }

    @Nullable
    public static Path zipToFile(@NonNull Path dir, @NonNull Path target, @Nullable Predicate<Path> filter) {
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (Files.exists(dir, new LinkOption[0])) {
            Path path;
            ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(target, new OpenOption[0]), StandardCharsets.UTF_8);
            try {
                ZipUtil.zipDir(out, dir, filter);
                path = target;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    LOGGER.debug("Exception while processing new zip entry from directory {}", (Object)dir, (Object)exception);
                }
            }
            out.close();
            return path;
        }
        return null;
    }

    private static void zipDir(final @NonNull ZipOutputStream out, final @NonNull Path dir, final @Nullable Predicate<Path> filter) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(@NonNull Path file, @NonNull BasicFileAttributes attrs) throws IOException {
                if (file == null) {
                    throw new NullPointerException("file is marked non-null but is null");
                }
                if (attrs == null) {
                    throw new NullPointerException("attrs is marked non-null but is null");
                }
                if (filter == null || filter.test(file)) {
                    try {
                        out.putNextEntry(new ZipEntry(dir.relativize(file).toString().replace("\\", "/")));
                        Files.copy(file, out);
                    }
                    finally {
                        out.closeEntry();
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Nullable
    public static Path extract(@NonNull Path zipPath, @NonNull Path targetDirectory) {
        if (zipPath == null) {
            throw new NullPointerException("zipPath is marked non-null but is null");
        }
        if (targetDirectory == null) {
            throw new NullPointerException("targetDirectory is marked non-null but is null");
        }
        if (Files.exists(zipPath, new LinkOption[0])) {
            Path path;
            block11: {
                InputStream inputStream = Files.newInputStream(zipPath, new OpenOption[0]);
                try {
                    path = ZipUtil.extract(inputStream, targetDirectory);
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException exception) {
                        LOGGER.debug("Unable to extract zip from {} to {}", zipPath, targetDirectory, exception);
                    }
                }
                inputStream.close();
            }
            return path;
        }
        return null;
    }

    @Nullable
    public static Path extract(@NonNull InputStream in, @NonNull Path targetDirectory) {
        ZipInputStream zipInputStream;
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (targetDirectory == null) {
            throw new NullPointerException("targetDirectory is marked non-null but is null");
        }
        return ZipUtil.extractZipStream(in instanceof ZipInputStream ? (zipInputStream = (ZipInputStream)in) : new ZipInputStream(in, StandardCharsets.UTF_8), targetDirectory);
    }

    @Nullable
    public static Path extractZipStream(@NonNull ZipInputStream zipInputStream, @NonNull Path targetDirectory) {
        if (zipInputStream == null) {
            throw new NullPointerException("zipInputStream is marked non-null but is null");
        }
        if (targetDirectory == null) {
            throw new NullPointerException("targetDirectory is marked non-null but is null");
        }
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ZipUtil.extractEntry(zipInputStream, zipEntry, targetDirectory);
                zipInputStream.closeEntry();
            }
            return targetDirectory;
        }
        catch (IOException exception) {
            LOGGER.debug("Exception unzipping zip file to {}", (Object)targetDirectory, (Object)exception);
            return null;
        }
    }

    private static void extractEntry(@NonNull ZipInputStream in, @NonNull ZipEntry zipEntry, @NonNull Path targetDirectory) throws IOException {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (zipEntry == null) {
            throw new NullPointerException("zipEntry is marked non-null but is null");
        }
        if (targetDirectory == null) {
            throw new NullPointerException("targetDirectory is marked non-null but is null");
        }
        ZipUtil.ensureSafeZipEntryName(zipEntry.getName());
        Path file = targetDirectory.resolve(zipEntry.getName());
        if (zipEntry.isDirectory()) {
            FileUtil.createDirectory(file);
        } else {
            FileUtil.createDirectory(file.getParent());
            try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
                FileUtil.copy((InputStream)in, outputStream);
            }
        }
    }

    private static void ensureSafeZipEntryName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (name.isEmpty() || name.startsWith("/") || name.startsWith("\\") || name.contains("..") || name.contains(":") && IS_WINDOWS) {
            throw new IllegalStateException(String.format("zip entry name %s contains unsafe characters", name));
        }
    }
}

