/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.io;

import io.vavr.CheckedConsumer;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.OutputStream;
import lombok.NonNull;

public final class ListenableOutputStream<O extends OutputStream>
extends OutputStream {
    private final O wrapped;
    private final CheckedConsumer<O> closeListener;

    public ListenableOutputStream(@NonNull O wrapped, @NonNull CheckedConsumer<O> closeListener) {
        if (wrapped == null) {
            throw new NullPointerException("wrapped is marked non-null but is null");
        }
        if (closeListener == null) {
            throw new NullPointerException("closeListener is marked non-null but is null");
        }
        this.wrapped = wrapped;
        this.closeListener = closeListener;
    }

    @Override
    public void write(int b) throws IOException {
        ((OutputStream)this.wrapped).write(b);
    }

    @Override
    public void write(byte @NonNull [] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        ((OutputStream)this.wrapped).write(b);
    }

    @Override
    public void write(byte @NonNull [] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        ((OutputStream)this.wrapped).write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        ((OutputStream)this.wrapped).flush();
    }

    @Override
    public void close() throws IOException {
        Try.of(() -> {
            this.closeListener.accept(this.wrapped);
            ((OutputStream)this.wrapped).close();
            return null;
        }).get();
    }
}

