/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.column;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.column.ColumnEntry;
import eu.cloudnetservice.common.column.ColumnFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;

public record RowedFormatter<T>(@NonNull ColumnFormatter defaultFormatter, @NonNull List<Function<T, Object>> columns) {
    @Generated
    public RowedFormatter(@NonNull ColumnFormatter defaultFormatter, @NonNull List<Function<T, Object>> columns) {
        if (defaultFormatter == null) {
            throw new NullPointerException("defaultFormatter is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
    }

    @NonNull
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @NonNull
    public ColumnEntry[] convertToColumns(@NonNull Collection<T> input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        ColumnEntry[] result = new ColumnEntry[this.columns.size()];
        List<Object> contents = input instanceof List ? (List<Object>)input : new LinkedList<T>(input);
        for (int i = 0; i < this.columns.size(); ++i) {
            String[] formatted = new String[input.size()];
            for (int y = 0; y < input.size(); ++y) {
                formatted[y] = Objects.toString(this.columns.get(i).apply(contents.get(y)));
            }
            ColumnEntry entry = ColumnEntry.wrap(formatted);
            if (entry.formattedEntries().length == 0 || i != 0 && result[i - 1].formattedEntries().length != entry.formattedEntries().length) {
                return new ColumnEntry[0];
            }
            result[i] = entry;
        }
        return result;
    }

    @NonNull
    public ColumnEntry[] convertToColumns(T ... input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.convertToColumns((Collection<T>)Arrays.asList(input));
    }

    @NonNull
    public Collection<String> format(@NonNull Collection<T> input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.defaultFormatter.formatLines(this.convertToColumns(input));
    }

    @NonNull
    public Collection<String> format(T ... input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.defaultFormatter.formatLines(this.convertToColumns(input));
    }

    public static final class Builder<T> {
        private ColumnFormatter defaultFormatter;
        private List<Function<T, Object>> columns = new LinkedList<Function<T, Object>>();

        @Contract(value="_ -> this", pure=true)
        @NonNull
        public Builder<T> defaultFormatter(@NonNull ColumnFormatter defaultFormatter) {
            if (defaultFormatter == null) {
                throw new NullPointerException("defaultFormatter is marked non-null but is null");
            }
            this.defaultFormatter = defaultFormatter;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NonNull
        public Builder<T> columns(@NonNull List<Function<T, Object>> columns) {
            if (columns == null) {
                throw new NullPointerException("columns is marked non-null but is null");
            }
            this.columns = new LinkedList<Function<T, Object>>(columns);
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NonNull
        public Builder<T> column(@NonNull Function<T, Object> converter) {
            if (converter == null) {
                throw new NullPointerException("converter is marked non-null but is null");
            }
            this.columns.add(converter);
            return this;
        }

        @NonNull
        public RowedFormatter<T> build() {
            Preconditions.checkNotNull(this.defaultFormatter, "no default formatter given");
            Preconditions.checkArgument(!this.columns.isEmpty(), "at least one column must be given");
            return new RowedFormatter<T>(this.defaultFormatter, new LinkedList<Function<T, Object>>(this.columns));
        }
    }
}

