/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.column;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.column.ColumnEntry;
import eu.cloudnetservice.common.util.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;

public final class ColumnFormatter {
    private static final String ENTRY_FORMAT = "%s%s%s%s%s";
    private final String leftSpacer;
    private final String rightSpacer;
    private final char columnLeftBracket;
    private final char columnRightBracket;
    private final char headerValuesSpacerChar;
    private final String[] columnTitles;
    private volatile Collection<String> formattedColumnTitles;

    private ColumnFormatter(@NonNull String leftSpacer, @NonNull String rightSpacer, char columnLeftBracket, char columnRightBracket, char headerValuesSpacerChar, @NonNull String[] columnTitles) {
        if (leftSpacer == null) {
            throw new NullPointerException("leftSpacer is marked non-null but is null");
        }
        if (rightSpacer == null) {
            throw new NullPointerException("rightSpacer is marked non-null but is null");
        }
        if (columnTitles == null) {
            throw new NullPointerException("columnTitles is marked non-null but is null");
        }
        this.leftSpacer = leftSpacer;
        this.rightSpacer = rightSpacer;
        this.columnLeftBracket = columnLeftBracket;
        this.columnRightBracket = columnRightBracket;
        this.headerValuesSpacerChar = headerValuesSpacerChar;
        this.columnTitles = columnTitles;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public Collection<String> formatLines(ColumnEntry ... entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        if (entries.length == 0) {
            if (this.formattedColumnTitles == null) {
                StringBuilder builder = new StringBuilder();
                for (String columnTitle : this.columnTitles) {
                    builder.append(String.format(ENTRY_FORMAT, Character.valueOf(this.columnLeftBracket), this.leftSpacer, columnTitle, this.rightSpacer, Character.valueOf(this.columnRightBracket)));
                }
                this.formattedColumnTitles = Collections.singleton(builder.toString());
            }
            return this.formattedColumnTitles;
        }
        String[] spaceCache = new String[entries.length];
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.columnTitles.length; ++i) {
            String ourSpaces;
            String title = this.columnTitles[i];
            int titleLength = title.length();
            if (titleLength > entries[i].columnMinLength()) {
                ourSpaces = "";
                spaceCache[i] = " ".repeat(titleLength - entries[i].columnMinLength());
            } else {
                ourSpaces = " ".repeat(entries[i].columnMinLength() - titleLength);
                spaceCache[i] = "";
            }
            builder.append(this.columnLeftBracket).append(this.leftSpacer).append(this.columnTitles[i]).append(ourSpaces).append(this.rightSpacer).append(this.columnRightBracket);
        }
        LinkedList<String> result = new LinkedList<String>();
        result.add(builder.toString());
        result.add(StringUtil.repeat(this.headerValuesSpacerChar, builder.length()));
        builder.setLength(0);
        int repeatCount = this.columnTitles.length * entries[0].formattedEntries().length;
        int currentDepth = 0;
        for (int i = 0; i <= repeatCount; ++i) {
            int index;
            if (i != 0 && i % this.columnTitles.length == 0) {
                result.add(builder.toString());
                builder.setLength(0);
                ++currentDepth;
                if (i == repeatCount) break;
            }
            if ((index = i - this.columnTitles.length * currentDepth) < 0) {
                index = i;
            }
            String spaces = spaceCache[index];
            builder.append(this.columnLeftBracket).append(this.leftSpacer).append(entries[index].formattedEntries()[currentDepth]).append(spaces).append(this.rightSpacer).append(this.columnRightBracket);
        }
        return result;
    }

    public static final class Builder {
        private String leftSpacer = " ";
        private String rightSpacer = "";
        private char columnLeftBracket = (char)124;
        private char columnRightBracket = (char)32;
        private char headerValuesSpacerChar = (char)8212;
        private String[] columnTitles = new String[0];

        @Contract(value="_ -> this", pure=true)
        @NonNull
        public Builder leftSpacer(@NonNull String leftSpacer) {
            if (leftSpacer == null) {
                throw new NullPointerException("leftSpacer is marked non-null but is null");
            }
            this.leftSpacer = leftSpacer;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NonNull
        public Builder rightSpacer(@NonNull String rightSpacer) {
            if (rightSpacer == null) {
                throw new NullPointerException("rightSpacer is marked non-null but is null");
            }
            this.rightSpacer = rightSpacer;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NonNull
        public Builder columnLeftBracket(char columnLeftBracket) {
            this.columnLeftBracket = columnLeftBracket;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NonNull
        public Builder columnRightBracket(char columnRightBracket) {
            this.columnRightBracket = columnRightBracket;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NonNull
        public Builder headerValuesSpacerChar(char headerValuesSpacerChar) {
            this.headerValuesSpacerChar = headerValuesSpacerChar;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NonNull
        public Builder columnTitles(@NonNull List<String> columnTitles) {
            if (columnTitles == null) {
                throw new NullPointerException("columnTitles is marked non-null but is null");
            }
            this.columnTitles = columnTitles.toArray(new String[0]);
            return this;
        }

        @NonNull
        public Builder columnTitles(String ... columnTitles) {
            if (columnTitles == null) {
                throw new NullPointerException("columnTitles is marked non-null but is null");
            }
            this.columnTitles = Arrays.copyOf(columnTitles, columnTitles.length);
            return this;
        }

        @Contract(value="-> new", pure=true)
        @NonNull
        public ColumnFormatter build() {
            Preconditions.checkArgument(this.columnTitles.length > 0, "At least one title must be given");
            return new ColumnFormatter(this.leftSpacer, this.rightSpacer, this.columnLeftBracket, this.columnRightBracket, this.headerValuesSpacerChar, this.columnTitles);
        }
    }
}

