/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.column;

import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Range;

public record ColumnEntry(@Range(from=0L, to=0x7FFFFFFFL) int columnMinLength, @NonNull String[] formattedEntries) {
    @Generated
    public ColumnEntry(@Range(from=0L, to=0x7FFFFFFFL) int columnMinLength, @NonNull String[] formattedEntries) {
        if (formattedEntries == null) {
            throw new NullPointerException("formattedEntries is marked non-null but is null");
        }
    }

    @NonNull
    public static ColumnEntry wrap(String ... entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        String[] entriesCopy = Arrays.copyOf(entries, entries.length);
        int longestLength = 0;
        for (String entry : entriesCopy) {
            longestLength = Math.max(longestLength, entry.length());
        }
        for (int i = 0; i < entriesCopy.length; ++i) {
            String entry = entriesCopy[i];
            int entryLength = entry.length();
            if (entryLength >= longestLength) continue;
            entriesCopy[i] = entry + " ".repeat(longestLength - entryLength);
        }
        return new ColumnEntry(longestLength, entriesCopy);
    }
}

