/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion.matcher;

import dev.derklaro.reflexion.internal.util.Util;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.intellij.lang.annotations.Language;

public abstract class BaseMatcher<T extends Member, M extends BaseMatcher<T, M>>
implements Predicate<T> {
    protected Predicate<T> currentMatcher = $2 -> true;

    @NonNull
    public M hasName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return (M)this.and((T member) -> member.getName().equals(name));
    }

    @NonNull
    public M hasMatchingName(@NonNull @Language(value="RegExp") String name, int ... flags) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        int compiledFlags = 0;
        if (flags.length > 0) {
            for (int flag : flags) {
                compiledFlags |= flag;
            }
        }
        Pattern pattern = Pattern.compile(name, compiledFlags);
        return (M)this.and((T member) -> pattern.matcher(member.getName()).matches());
    }

    @NonNull
    public M hasModifier(int mod) {
        return (M)this.and((T member) -> (member.getModifiers() & mod) == mod);
    }

    @NonNull
    public M hasModifiers(int ... mods) {
        int mod = 0;
        for (int i : mods) {
            mod |= i;
        }
        return this.hasModifier(mod);
    }

    @NonNull
    public M denyModifier(int mod) {
        return (M)this.and((T member) -> (member.getModifiers() & mod) != mod);
    }

    @NonNull
    public M denyModifiers(int ... mods) {
        int mod = 0;
        for (int i : mods) {
            mod |= i;
        }
        return this.denyModifier(mod);
    }

    @NonNull
    public M exactType(@NonNull Function<T, Class<?>> typeReader, @NonNull Class<?> expectedType) {
        if (typeReader == null) {
            throw new NullPointerException("typeReader is marked non-null but is null");
        }
        if (expectedType == null) {
            throw new NullPointerException("expectedType is marked non-null but is null");
        }
        return (M)this.and((T member) -> {
            Class type = (Class)typeReader.apply(member);
            return type != null && type.equals(expectedType);
        });
    }

    @NonNull
    public M superType(@NonNull Function<T, Class<?>> typeReader, @NonNull Class<?> expectedType) {
        if (typeReader == null) {
            throw new NullPointerException("typeReader is marked non-null but is null");
        }
        if (expectedType == null) {
            throw new NullPointerException("expectedType is marked non-null but is null");
        }
        return (M)this.and((T member) -> {
            Class type = (Class)typeReader.apply(member);
            return type != null && type.isAssignableFrom(expectedType);
        });
    }

    @NonNull
    public M derivedType(@NonNull Function<T, Class<?>> typeReader, @NonNull Class<?> expectedType) {
        if (typeReader == null) {
            throw new NullPointerException("typeReader is marked non-null but is null");
        }
        if (expectedType == null) {
            throw new NullPointerException("expectedType is marked non-null but is null");
        }
        return (M)this.and((T member) -> {
            Class type = (Class)typeReader.apply(member);
            return type != null && expectedType.isAssignableFrom(type);
        });
    }

    @NonNull
    public M exactTypes(@NonNull Function<T, Class<?>[]> typesReader, Class<?> ... expectedTypes) {
        if (typesReader == null) {
            throw new NullPointerException("typesReader is marked non-null but is null");
        }
        if (expectedTypes == null) {
            throw new NullPointerException("expectedTypes is marked non-null but is null");
        }
        return (M)this.and((T member) -> {
            Object[] types = (Class[])typesReader.apply(member);
            return types != null && Arrays.equals(types, expectedTypes);
        });
    }

    @NonNull
    public M superTypes(@NonNull Function<T, Class<?>[]> typesReader, Class<?> ... expectedTypes) {
        if (typesReader == null) {
            throw new NullPointerException("typesReader is marked non-null but is null");
        }
        if (expectedTypes == null) {
            throw new NullPointerException("expectedTypes is marked non-null but is null");
        }
        return (M)this.and((T member) -> {
            Class[] types = (Class[])typesReader.apply(member);
            return Util.allMatch(expectedTypes, types, (expected, actual) -> actual.isAssignableFrom((Class<?>)expected));
        });
    }

    @NonNull
    public M derivedTypes(@NonNull Function<T, Class<?>[]> reader, Class<?> ... expectedTypes) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (expectedTypes == null) {
            throw new NullPointerException("expectedTypes is marked non-null but is null");
        }
        return (M)this.and((T member) -> {
            Class[] types = (Class[])reader.apply(member);
            return Util.allMatch(expectedTypes, types, Class::isAssignableFrom);
        });
    }

    @NonNull
    public M exactTypeAt(@NonNull Function<T, Class<?>[]> typesReader, @NonNull Class<?> expectedType, int idx) {
        if (typesReader == null) {
            throw new NullPointerException("typesReader is marked non-null but is null");
        }
        if (expectedType == null) {
            throw new NullPointerException("expectedType is marked non-null but is null");
        }
        return (M)this.and((T member) -> {
            Class[] types = (Class[])typesReader.apply(member);
            return types != null && idx >= 0 && types.length > idx && types[idx].equals(expectedType);
        });
    }

    @NonNull
    public M superTypeAt(@NonNull Function<T, Class<?>[]> typesReader, @NonNull Class<?> expectedType, int idx) {
        if (typesReader == null) {
            throw new NullPointerException("typesReader is marked non-null but is null");
        }
        if (expectedType == null) {
            throw new NullPointerException("expectedType is marked non-null but is null");
        }
        return (M)this.and((T member) -> {
            Class[] types = (Class[])typesReader.apply(member);
            return types != null && idx >= 0 && types.length > idx && types[idx].isAssignableFrom(expectedType);
        });
    }

    @NonNull
    public M derivedTypeAt(@NonNull Function<T, Class<?>[]> reader, @NonNull Class<?> expectedType, int idx) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (expectedType == null) {
            throw new NullPointerException("expectedType is marked non-null but is null");
        }
        return (M)this.and((T member) -> {
            Class[] types = (Class[])reader.apply(member);
            return types != null && idx >= 0 && types.length > idx && expectedType.isAssignableFrom(types[idx]);
        });
    }

    @Override
    public boolean test(T t) {
        return this.currentMatcher.test(t);
    }

    @NonNull
    public M and(@NonNull Predicate<? super T> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        this.currentMatcher = this.currentMatcher.and(other);
        return (M)this;
    }

    @NonNull
    public M or(@NonNull Predicate<? super T> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        this.currentMatcher = this.currentMatcher.or(other);
        return (M)this;
    }

    @NonNull
    public M negate() {
        this.currentMatcher = this.currentMatcher.negate();
        return (M)this;
    }
}

