/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion.internal.util;

import dev.derklaro.reflexion.Reflexion;
import dev.derklaro.reflexion.ReflexionException;
import dev.derklaro.reflexion.internal.util.Exceptions;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

public final class Util {
    private Util() {
        throw new UnsupportedOperationException();
    }

    public static <K, V> @Unmodifiable Map<K, V> newMapFromArray(Object ... entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        if (entries.length == 0) {
            return Collections.emptyMap();
        }
        if (entries.length == 2) {
            return Collections.singletonMap(entries[0], entries[1]);
        }
        if (entries.length % 2 != 0) {
            throw new ReflexionException("Given map based array has unexpected size of " + entries.length);
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(entries.length + 1, 1.0f);
        for (int i = 0; i < entries.length; i += 2) {
            map.put(entries[i], entries[i + 1]);
        }
        return map;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static int fastModulo(int leftOperator, int rightOperator) {
        return leftOperator & rightOperator - 1;
    }

    @SafeVarargs
    public static <T> @UnknownNullability T firstNonNull(T ... choices) {
        if (choices.length == 0) {
            return null;
        }
        if (choices.length == 1) {
            return choices[0];
        }
        if (choices.length == 2) {
            T left = choices[0];
            T right = choices[1];
            return left == null ? right : left;
        }
        for (T choice : choices) {
            if (choice == null) continue;
            return choice;
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static <T extends Throwable> void throwUnchecked(@NonNull Throwable throwable) throws T {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        Exceptions.throwUnchecked(throwable);
    }

    public static <T> boolean allMatch(@Nullable T[] leftArr, @Nullable T[] rightArr, @NonNull BiPredicate<T, T> tester) {
        if (tester == null) {
            throw new NullPointerException("tester is marked non-null but is null");
        }
        if (leftArr == null || rightArr == null) {
            return leftArr == null && rightArr == null;
        }
        if (leftArr == rightArr || leftArr.length == 0 && rightArr.length == 0) {
            return true;
        }
        if (leftArr.length != rightArr.length) {
            return false;
        }
        if (leftArr.length == 1) {
            return tester.test(leftArr[0], rightArr[0]);
        }
        for (int i = 0; i < leftArr.length; ++i) {
            if (tester.test(leftArr[i], rightArr[i])) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public static <T, O> Collection<O> filterAndMap(@NonNull Collection<T> in, @NonNull Predicate<T> tester, @NonNull Function<T, O> mapper) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (tester == null) {
            throw new NullPointerException("tester is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        if (in.isEmpty()) {
            return Collections.emptySet();
        }
        if (in.size() == 1) {
            T firstElement = in.iterator().next();
            return tester.test(firstElement) ? Collections.singleton(mapper.apply(firstElement)) : Collections.emptySet();
        }
        HashSet<O> out = new HashSet<O>();
        for (T t : in) {
            if (!tester.test(t)) continue;
            out.add(mapper.apply(t));
        }
        return out;
    }

    public static boolean isClassPresent(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        try {
            ClassLoader cl = Util.firstNonNull(Util.class.getClassLoader(), Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader());
            Class.forName(name, false, cl);
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    @Nullable
    public static Object getBinding(@NonNull Reflexion reflexionInstance, @Nullable Object requestedBinding, int modifiers) {
        if (reflexionInstance == null) {
            throw new NullPointerException("reflexionInstance is marked non-null but is null");
        }
        if (Modifier.isStatic(modifiers)) {
            return null;
        }
        Object binding = Util.firstNonNull(requestedBinding, reflexionInstance.getBinding());
        if (binding == null) {
            throw new IllegalArgumentException("Missing binding to execute action on non-static accessor");
        }
        return binding;
    }

    public static void ensureTrue(boolean condition, @NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

