/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion.internal.util;

import lombok.NonNull;

public final class Exceptions {
    private Exceptions() {
        throw new UnsupportedOperationException();
    }

    public static <T extends Throwable> void throwUnchecked(@NonNull Throwable throwable) throws T {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        throw throwable;
    }

    public static boolean isFatal(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        return throwable instanceof InterruptedException || throwable instanceof LinkageError || throwable instanceof ThreadDeath || throwable instanceof VirtualMachineError;
    }

    public static void rethrowIfFatal(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        if (Exceptions.isFatal(throwable)) {
            Exceptions.throwUnchecked(throwable);
        }
    }
}

