/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion.internal.unsafe;

import dev.derklaro.reflexion.internal.unsafe.UnsafeAccess;
import dev.derklaro.reflexion.internal.util.Util;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import lombok.NonNull;

public final class UnsafeAccessibleObject {
    private static final long ACCESSIBLE_OFFSET;
    private static final Object SOME_FIELD;

    private UnsafeAccessibleObject() {
        throw new UnsupportedOperationException();
    }

    public static boolean isAvailable() {
        return ACCESSIBLE_OFFSET != -1L;
    }

    public static void makeAccessible(@NonNull AccessibleObject accessibleObject) {
        if (accessibleObject == null) {
            throw new NullPointerException("accessibleObject is marked non-null but is null");
        }
        Util.ensureTrue(UnsafeAccessibleObject.isAvailable(), "UnsafeAccessibleObject couldn't be initialized an is unusable");
        UnsafeAccess.invokeMethod("putByte", new Class[]{Object.class, Long.TYPE, Byte.TYPE}, accessibleObject, ACCESSIBLE_OFFSET, (byte)1);
    }

    static {
        SOME_FIELD = new Object();
        long offset = -1L;
        if (UnsafeAccess.isAvailable()) {
            try {
                Field inaccessibleField = UnsafeAccessibleObject.class.getDeclaredField("SOME_FIELD");
                Field accessibleField = UnsafeAccessibleObject.class.getDeclaredField("SOME_FIELD");
                accessibleField.setAccessible(true);
                for (long off = 8L; off < 128L; ++off) {
                    Byte inaccessible = (Byte)UnsafeAccess.invokeMethod("getByte", new Class[]{Object.class, Long.TYPE}, inaccessibleField, off);
                    Byte accessible = (Byte)UnsafeAccess.invokeMethod("getByte", new Class[]{Object.class, Long.TYPE}, accessibleField, off);
                    if (inaccessible == null || accessible == null || inaccessible != 0 || accessible != 1) continue;
                    offset = off;
                    break;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        ACCESSIBLE_OFFSET = offset;
    }
}

