/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion.internal.unsafe;

import dev.derklaro.reflexion.internal.util.Util;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import lombok.NonNull;
import org.jetbrains.annotations.UnknownNullability;

public final class UnsafeAccess {
    private static final Object THE_UNSAFE;

    private UnsafeAccess() {
        throw new UnsupportedOperationException();
    }

    public static boolean isAvailable() {
        return THE_UNSAFE != null;
    }

    public static @UnknownNullability Object invokeMethod(@NonNull String methodName, @NonNull Class<?>[] argTypes, Object ... args) {
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        if (argTypes == null) {
            throw new NullPointerException("argTypes is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        Util.ensureTrue(UnsafeAccess.isAvailable(), "UnsafeAccess couldn't be initialized an is unusable");
        try {
            Method method = THE_UNSAFE.getClass().getMethod(methodName, argTypes);
            return method.invoke(THE_UNSAFE, args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        Object unsafeInstance = null;
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafeInstance = theUnsafe.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        THE_UNSAFE = unsafeInstance;
    }
}

