/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion.internal.natives;

import dev.derklaro.reflexion.Result;
import dev.derklaro.reflexion.internal.util.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import lombok.NonNull;

final class NativeLibLoader {
    private static final boolean NATIVE_DISABLED = Boolean.getBoolean(Result.class.getPackage().getName() + ".native-disabled");
    private static final Os UNSUPPORTED_OS = new Os("unsupported", "", "");
    private static final String NATIVE_LIB_FILE_FORMAT = "reflexion-native/reflexion-%s_%s/%sreflexion.%s";
    private static final Os OS;
    private static final String OS_ARCH;

    private NativeLibLoader() {
        throw new UnsupportedOperationException();
    }

    public static boolean tryLoadNative() {
        Path temp;
        if (NATIVE_DISABLED || OS == UNSUPPORTED_OS || OS_ARCH.equals("unsupported")) {
            return false;
        }
        String file = String.format(NATIVE_LIB_FILE_FORMAT, OS.name, OS_ARCH, OS.libPrefix, OS.libExtension);
        InputStream nativeLibStream = NativeLibLoader.class.getClassLoader().getResourceAsStream(file);
        if (nativeLibStream == null) {
            return false;
        }
        try {
            temp = Files.createTempFile("reflexion-", file.substring(file.lastIndexOf(46)), new FileAttribute[0]);
            Files.copy(nativeLibStream, temp, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException exception) {
            return false;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Files.deleteIfExists(temp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
        try {
            System.load(temp.toAbsolutePath().toString());
            return true;
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof LinkageError)) {
                Exceptions.rethrowIfFatal(throwable);
            }
            return false;
        }
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        OS = osName.startsWith("linux") || osName.equals("netbsd") ? new Os("linux", "lib", "so") : (osName.startsWith("windows") ? new Os("windows", "", "dll") : (osName.startsWith("mac") ? new Os("mac", "lib", "dylib") : UNSUPPORTED_OS));
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        OS_ARCH = arch.equals("amd64") || arch.equals("x86_64") ? "x86_64" : (arch.startsWith("arm") ? "arm" : (arch.equals("aarch64") ? "aarch64" : "unsupported"));
    }

    private static final class Os {
        private final String name;
        private final String libPrefix;
        private final String libExtension;

        public Os(@NonNull String name, @NonNull String libPrefix, @NonNull String libExtension) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (libPrefix == null) {
                throw new NullPointerException("libPrefix is marked non-null but is null");
            }
            if (libExtension == null) {
                throw new NullPointerException("libExtension is marked non-null but is null");
            }
            this.name = name;
            this.libPrefix = libPrefix;
            this.libExtension = libExtension;
        }
    }
}

