/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion.internal.jna;

import com.sun.jna.FunctionMapper;
import com.sun.jna.JNIEnv;
import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.HashMap;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class JnaImplLookupAccessor {
    private static final int INITIAL_READ_BUFFER_SIZE = 512;
    private static final String JVM_LIB_NAME = "jvm";
    private static final String JVM_LIB_NAME_MACOS = "java";
    private static final String ACCESS_CLASS_INTERNAL_NAME = "java/lang/invoke/ImplLookupAccess";
    private static final String ACCESS_CLASS_JVM_NAME = "java/lang/invoke/ImplLookupAccess".replace('/', '.');

    private JnaImplLookupAccessor() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static MethodHandles.Lookup tryGetImplLookup() {
        Class<?> ila;
        try {
            Jvm jvmAccess = JnaImplLookupAccessor.loadJvmJnaAccess();
            byte[] accessClassBytecode = JnaImplLookupAccessor.loadAccessClassByteCode();
            ila = jvmAccess.JVM_DefineClass(JNIEnv.CURRENT, ACCESS_CLASS_INTERNAL_NAME, null, accessClassBytecode, accessClassBytecode.length, null);
        }
        catch (LinkageError error) {
            try {
                ila = Class.forName(ACCESS_CLASS_JVM_NAME);
            }
            catch (ClassNotFoundException exception) {
                return null;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        try {
            Method implLookupGetter = ila.getMethod("getImplLookup", new Class[0]);
            return (MethodHandles.Lookup)implLookupGetter.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException exception) {
            return null;
        }
    }

    private static byte[] loadAccessClassByteCode() throws IOException {
        try (ByteArrayOutputStream target = new ByteArrayOutputStream(512);){
            byte[] byArray;
            block13: {
                InputStream in = JnaImplLookupAccessor.class.getClassLoader().getResourceAsStream("jna/ImplLookupAccess.class");
                try {
                    int transferredBytes;
                    if (in == null) {
                        throw new IllegalStateException("LookupAccess class is missing");
                    }
                    byte[] readBuffer = new byte[512];
                    while ((transferredBytes = in.read(readBuffer)) != -1) {
                        target.write(readBuffer, 0, transferredBytes);
                    }
                    byArray = target.toByteArray();
                    if (in == null) break block13;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return byArray;
        }
    }

    @NonNull
    private static Jvm loadJvmJnaAccess() {
        HashMap<String, Object> loadOptions = new HashMap<String, Object>();
        loadOptions.put("allow-objects", true);
        if (Platform.isWindows() && !Platform.is64Bit()) {
            loadOptions.put("function-mapper", new Win32FunctionMapper());
        }
        String jvmLibName = Platform.isMac() ? JVM_LIB_NAME_MACOS : JVM_LIB_NAME;
        return (Jvm)Native.load((String)jvmLibName, Jvm.class, loadOptions);
    }

    static interface Jvm
    extends Library {
        public Class<?> JVM_DefineClass(JNIEnv var1, String var2, ClassLoader var3, byte[] var4, int var5, ProtectionDomain var6) throws LastErrorException;
    }

    private static final class Win32FunctionMapper
    implements FunctionMapper {
        private Win32FunctionMapper() {
        }

        public String getFunctionName(@NonNull NativeLibrary library, @NonNull Method method) {
            if (library == null) {
                throw new NullPointerException("library is marked non-null but is null");
            }
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (method.getName().equals("JVM_DefineClass")) {
                return "_JVM_DefineClass@24";
            }
            return method.getName();
        }
    }
}

