/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion.internal.handles;

import dev.derklaro.reflexion.AccessorFactory;
import dev.derklaro.reflexion.FieldAccessor;
import dev.derklaro.reflexion.MethodAccessor;
import dev.derklaro.reflexion.Reflexion;
import dev.derklaro.reflexion.ReflexionException;
import dev.derklaro.reflexion.Result;
import dev.derklaro.reflexion.internal.bare.BareAccessorFactory;
import dev.derklaro.reflexion.internal.handles.ImplLookupAccessor;
import dev.derklaro.reflexion.internal.jna.JnaAccessorFactory;
import dev.derklaro.reflexion.internal.natives.NativeAccessorFactory;
import dev.derklaro.reflexion.internal.util.Util;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class MethodHandleAccessorFactory
implements AccessorFactory {
    private final MethodHandles.Lookup trustedLookup = this.getTrustedLookup();

    @Override
    public boolean isAvailable() {
        return this.trustedLookup != null;
    }

    @Override
    @NonNull
    public FieldAccessor wrapField(@NonNull Reflexion reflexion, @NonNull Field field) {
        if (reflexion == null) {
            throw new NullPointerException("reflexion is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        try {
            boolean staticField = Modifier.isStatic(field.getModifiers());
            MethodHandle getter = this.convertFieldToGeneric(field, staticField, false);
            MethodHandle setter = this.convertFieldToGeneric(field, staticField, true);
            return new MethodHandleFieldAccessor(field, reflexion, getter, setter);
        }
        catch (Exception exception) {
            throw new ReflexionException(exception);
        }
    }

    @Override
    @NonNull
    public MethodAccessor<Method> wrapMethod(@NonNull Reflexion reflexion, @NonNull Method method) {
        if (reflexion == null) {
            throw new NullPointerException("reflexion is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        try {
            MethodHandle unreflected = this.trustedLookup.unreflect(method);
            boolean staticMethod = Modifier.isStatic(method.getModifiers());
            return new MethodHandleMethodAccessor(method, reflexion, this.convertToGeneric(unreflected, staticMethod, false));
        }
        catch (Exception exception) {
            throw new ReflexionException(exception);
        }
    }

    @Override
    @NonNull
    public MethodAccessor<Constructor<?>> wrapConstructor(@NonNull Reflexion rfx, @NonNull Constructor<?> ctr) {
        if (rfx == null) {
            throw new NullPointerException("rfx is marked non-null but is null");
        }
        if (ctr == null) {
            throw new NullPointerException("ctr is marked non-null but is null");
        }
        try {
            MethodHandle unreflected = this.trustedLookup.unreflectConstructor(ctr);
            return new MethodHandleConstructorAccessor(ctr, rfx, this.convertToGeneric(unreflected, false, true));
        }
        catch (Exception exception) {
            throw new ReflexionException(exception);
        }
    }

    @Nullable
    protected MethodHandles.Lookup getTrustedLookup() {
        return ImplLookupAccessor.findImplLookup();
    }

    @NonNull
    private MethodHandle convertToGeneric(@NonNull MethodHandle handle, boolean staticMethod, boolean ctor) {
        if (handle == null) {
            throw new NullPointerException("handle is marked non-null but is null");
        }
        MethodHandle target = handle.asFixedArity();
        int paramCount = handle.type().parameterCount() - (ctor || staticMethod ? 0 : 1);
        MethodType methodType = MethodType.genericMethodType(ctor ? 0 : 1, paramCount > 0);
        if (paramCount > 0) {
            target = target.asSpreader(Object[].class, paramCount);
        }
        if (staticMethod) {
            target = MethodHandles.dropArguments(target, 0, new Class[]{Object.class});
        }
        return target.asType(methodType);
    }

    @NonNull
    private MethodHandle convertFieldToGeneric(@NonNull Field field, boolean staticField, boolean set) throws Exception {
        MethodHandle handle;
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (staticField) {
            handle = set ? this.trustedLookup.findStaticSetter(field.getDeclaringClass(), field.getName(), field.getType()) : this.trustedLookup.findStaticGetter(field.getDeclaringClass(), field.getName(), field.getType());
        } else {
            MethodHandle methodHandle = handle = set ? this.trustedLookup.findSetter(field.getDeclaringClass(), field.getName(), field.getType()) : this.trustedLookup.findGetter(field.getDeclaringClass(), field.getName(), field.getType());
        }
        MethodType mt = staticField ? (set ? MethodType.methodType(Void.TYPE, Object.class) : MethodType.methodType(Object.class)) : (set ? MethodType.methodType(Void.TYPE, Object.class, Object.class) : MethodType.methodType(Object.class, Object.class));
        return handle.asType(mt);
    }

    @Override
    public int compareTo(@NonNull AccessorFactory o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        if (o instanceof NativeAccessorFactory || o instanceof JnaAccessorFactory) {
            return 1;
        }
        if (o instanceof BareAccessorFactory) {
            return this.trustedLookup != null ? -1 : 1;
        }
        if (o instanceof MethodHandleAccessorFactory) {
            return this.trustedLookup != null ? -1 : (((MethodHandleAccessorFactory)o).trustedLookup != null ? 1 : 0);
        }
        return 0;
    }

    private static final class MethodHandleFieldAccessor
    implements FieldAccessor {
        private final Field field;
        private final Reflexion reflexion;
        private final MethodHandle getter;
        private final MethodHandle setter;

        public MethodHandleFieldAccessor(Field field, Reflexion reflexion, MethodHandle getter, MethodHandle setter) {
            this.field = field;
            this.reflexion = reflexion;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        @NonNull
        public Field getMember() {
            return this.field;
        }

        @Override
        @NonNull
        public Reflexion getReflexion() {
            return this.reflexion;
        }

        @Override
        @NonNull
        public <T> Result<T> getValue() {
            return this.getValue(null);
        }

        @Override
        @NonNull
        public <T> Result<T> getValue(@Nullable Object instance) {
            return Result.tryExecute(() -> {
                Object binding = Util.getBinding(this.reflexion, instance, this.field.getModifiers());
                return binding == null ? this.getter.invoke() : this.getter.invoke(binding);
            });
        }

        @Override
        @NonNull
        public Result<Void> setValue(@Nullable Object value) {
            return this.setValue(null, value);
        }

        @Override
        @NonNull
        public Result<Void> setValue(@Nullable Object instance, @Nullable Object value) {
            return Result.tryExecute(() -> {
                Object binding = Util.getBinding(this.reflexion, instance, this.field.getModifiers());
                if (binding == null) {
                    this.setter.invoke(value);
                } else {
                    this.setter.invoke(binding, value);
                }
                return null;
            });
        }
    }

    private static final class MethodHandleMethodAccessor
    implements MethodAccessor<Method> {
        private final Method method;
        private final Reflexion reflexion;
        private final MethodHandle methodHandle;

        public MethodHandleMethodAccessor(Method method, Reflexion reflexion, MethodHandle methodHandle) {
            this.method = method;
            this.reflexion = reflexion;
            this.methodHandle = methodHandle;
        }

        @Override
        @NonNull
        public Method getMember() {
            return this.method;
        }

        @Override
        @NonNull
        public Reflexion getReflexion() {
            return this.reflexion;
        }

        @Override
        @NonNull
        public <V> Result<V> invoke() {
            return this.invoke(null);
        }

        @Override
        @NonNull
        public <V> Result<V> invoke(@Nullable Object instance) {
            return Result.tryExecute(() -> {
                Object binding = Util.getBinding(this.reflexion, instance, this.method.getModifiers());
                return this.methodHandle.invoke(binding);
            });
        }

        @Override
        @NonNull
        public <V> Result<V> invokeWithArgs(Object ... args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            return this.invoke(null, args);
        }

        @Override
        @NonNull
        public <V> Result<V> invoke(@Nullable Object instance, Object ... args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            if (args.length == 0) {
                return this.invoke(instance);
            }
            return Result.tryExecute(() -> {
                Object binding = Util.getBinding(this.reflexion, instance, this.method.getModifiers());
                return this.methodHandle.invoke(binding, args);
            });
        }
    }

    private static final class MethodHandleConstructorAccessor
    implements MethodAccessor<Constructor<?>> {
        private final Reflexion reflexion;
        private final Constructor<?> method;
        private final MethodHandle methodHandle;

        public MethodHandleConstructorAccessor(Constructor<?> method, Reflexion reflexion, MethodHandle methodHandle) {
            this.method = method;
            this.reflexion = reflexion;
            this.methodHandle = methodHandle;
        }

        @Override
        @NonNull
        public Constructor<?> getMember() {
            return this.method;
        }

        @Override
        @NonNull
        public Reflexion getReflexion() {
            return this.reflexion;
        }

        @Override
        @NonNull
        public <V> Result<V> invoke() {
            return this.invoke(null);
        }

        @Override
        @NonNull
        public <V> Result<V> invoke(@Nullable Object instance) {
            return Result.tryExecute(() -> this.methodHandle.invoke());
        }

        @Override
        @NonNull
        public <V> Result<V> invokeWithArgs(Object ... args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            return this.invoke(null, args);
        }

        @Override
        @NonNull
        public <V> Result<V> invoke(@Nullable Object instance, Object ... args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            if (args.length == 0) {
                return this.invoke(null);
            }
            return Result.tryExecute(() -> this.methodHandle.invoke(args));
        }
    }
}

