/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion.internal.handles;

import dev.derklaro.reflexion.internal.unsafe.UnsafeAccess;
import dev.derklaro.reflexion.internal.unsafe.UnsafeAccessibleObject;
import dev.derklaro.reflexion.internal.util.Util;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

final class ImplLookupAccessor {
    private ImplLookupAccessor() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static MethodHandles.Lookup findImplLookup() {
        return Util.firstNonNull(ImplLookupAccessor.tryResolveUsingDirectAccess(), ImplLookupAccessor.tryResolveUsingUnsafeGetObject(), ImplLookupAccessor.tryResolveUsingUnsafeAccessibleObject());
    }

    @Nullable
    private static MethodHandles.Lookup tryResolveUsingDirectAccess() {
        try {
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            implLookupField.setAccessible(true);
            return (MethodHandles.Lookup)implLookupField.get(null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @VisibleForTesting
    @Nullable
    static MethodHandles.Lookup tryResolveUsingUnsafeGetObject() {
        if (UnsafeAccess.isAvailable()) {
            try {
                Field lookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                Object implBase = UnsafeAccess.invokeMethod("staticFieldBase", new Class[]{Field.class}, lookupField);
                Long offset = (Long)UnsafeAccess.invokeMethod("staticFieldOffset", new Class[]{Field.class}, lookupField);
                if (implBase != null && offset != null) {
                    return (MethodHandles.Lookup)UnsafeAccess.invokeMethod("getObject", new Class[]{Object.class, Long.TYPE}, implBase, offset);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static MethodHandles.Lookup tryResolveUsingUnsafeAccessibleObject() {
        if (UnsafeAccessibleObject.isAvailable()) {
            try {
                Field lookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                UnsafeAccessibleObject.makeAccessible(lookupField);
                return (MethodHandles.Lookup)lookupField.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

