/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion.internal.bare;

import dev.derklaro.reflexion.AccessorFactory;
import dev.derklaro.reflexion.FieldAccessor;
import dev.derklaro.reflexion.MethodAccessor;
import dev.derklaro.reflexion.Reflexion;
import dev.derklaro.reflexion.ReflexionException;
import dev.derklaro.reflexion.Result;
import dev.derklaro.reflexion.internal.unsafe.UnsafeAccessibleObject;
import dev.derklaro.reflexion.internal.util.Util;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class BareAccessorFactory
implements AccessorFactory {
    private static void makeAccessible(@NonNull AccessibleObject accessibleObject) {
        if (accessibleObject == null) {
            throw new NullPointerException("accessibleObject is marked non-null but is null");
        }
        if (UnsafeAccessibleObject.isAvailable()) {
            UnsafeAccessibleObject.makeAccessible(accessibleObject);
        } else {
            accessibleObject.setAccessible(true);
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    @NonNull
    public FieldAccessor wrapField(@NonNull Reflexion reflexion, @NonNull Field field) {
        if (reflexion == null) {
            throw new NullPointerException("reflexion is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        try {
            BareAccessorFactory.makeAccessible(field);
            return new BareFieldAccessor(field, reflexion);
        }
        catch (Exception exception) {
            throw new ReflexionException(exception);
        }
    }

    @Override
    @NonNull
    public MethodAccessor<Method> wrapMethod(@NonNull Reflexion reflexion, @NonNull Method method) {
        if (reflexion == null) {
            throw new NullPointerException("reflexion is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        try {
            BareAccessorFactory.makeAccessible(method);
            return new BareMethodAccessor(method, reflexion);
        }
        catch (Exception exception) {
            throw new ReflexionException(exception);
        }
    }

    @Override
    @NonNull
    public MethodAccessor<Constructor<?>> wrapConstructor(@NonNull Reflexion rfx, @NonNull Constructor<?> ctr) {
        if (rfx == null) {
            throw new NullPointerException("rfx is marked non-null but is null");
        }
        if (ctr == null) {
            throw new NullPointerException("ctr is marked non-null but is null");
        }
        try {
            BareAccessorFactory.makeAccessible(ctr);
            return new BareConstructorAccessor(rfx, ctr);
        }
        catch (Exception exception) {
            throw new ReflexionException(exception);
        }
    }

    @Override
    public int compareTo(@NonNull AccessorFactory o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return o instanceof BareAccessorFactory ? 0 : 1;
    }

    private static final class BareFieldAccessor
    implements FieldAccessor {
        private final Field field;
        private final Reflexion reflexion;

        public BareFieldAccessor(Field field, Reflexion reflexion) {
            this.field = field;
            this.reflexion = reflexion;
        }

        @Override
        @NonNull
        public Field getMember() {
            return this.field;
        }

        @Override
        @NonNull
        public Reflexion getReflexion() {
            return this.reflexion;
        }

        @Override
        @NonNull
        public <T> Result<T> getValue() {
            return this.getValue(null);
        }

        @Override
        @NonNull
        public <T> Result<T> getValue(@Nullable Object instance) {
            return Result.tryExecute(() -> {
                Object binding = Util.getBinding(this.reflexion, instance, this.field.getModifiers());
                return this.field.get(binding);
            });
        }

        @Override
        @NonNull
        public Result<Void> setValue(@Nullable Object value) {
            return this.setValue(null, value);
        }

        @Override
        @NonNull
        public Result<Void> setValue(@Nullable Object instance, @Nullable Object value) {
            return Result.tryExecute(() -> {
                Object binding = Util.getBinding(this.reflexion, instance, this.field.getModifiers());
                this.field.set(binding, value);
                return null;
            });
        }
    }

    private static final class BareMethodAccessor
    implements MethodAccessor<Method> {
        private final Method method;
        private final Reflexion reflexion;

        public BareMethodAccessor(Method method, Reflexion reflexion) {
            this.method = method;
            this.reflexion = reflexion;
        }

        @Override
        @NonNull
        public Method getMember() {
            return this.method;
        }

        @Override
        @NonNull
        public Reflexion getReflexion() {
            return this.reflexion;
        }

        @Override
        @NonNull
        public <V> Result<V> invoke() {
            return this.invoke(null);
        }

        @Override
        @NonNull
        public <V> Result<V> invoke(@Nullable Object instance) {
            return Result.tryExecute(() -> {
                Object binding = Util.getBinding(this.reflexion, instance, this.method.getModifiers());
                return this.method.invoke(binding, new Object[0]);
            });
        }

        @Override
        @NonNull
        public <V> Result<V> invokeWithArgs(Object ... args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            return this.invoke(null, args);
        }

        @Override
        @NonNull
        public <V> Result<V> invoke(@Nullable Object instance, Object ... args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            return Result.tryExecute(() -> {
                Object binding = Util.getBinding(this.reflexion, instance, this.method.getModifiers());
                return this.method.invoke(binding, args);
            });
        }
    }

    private static final class BareConstructorAccessor
    implements MethodAccessor<Constructor<?>> {
        private final Reflexion reflexion;
        private final Constructor<?> constructor;

        public BareConstructorAccessor(Reflexion reflexion, Constructor<?> constructor) {
            this.reflexion = reflexion;
            this.constructor = constructor;
        }

        @Override
        @NonNull
        public Constructor<?> getMember() {
            return this.constructor;
        }

        @Override
        @NonNull
        public Reflexion getReflexion() {
            return this.reflexion;
        }

        @Override
        @NonNull
        public <V> Result<V> invoke() {
            return Result.tryExecute(() -> this.constructor.newInstance(new Object[0]));
        }

        @Override
        @NonNull
        public <V> Result<V> invoke(@Nullable Object instance) {
            return this.invoke();
        }

        @Override
        @NonNull
        public <V> Result<V> invokeWithArgs(Object ... args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            return Result.tryExecute(() -> this.constructor.newInstance(args));
        }

        @Override
        @NonNull
        public <V> Result<V> invoke(@Nullable Object instance, Object ... args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            return this.invokeWithArgs(args);
        }
    }
}

