/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion.internal;

import dev.derklaro.reflexion.AccessorFactory;
import dev.derklaro.reflexion.internal.bare.BareAccessorFactory;
import dev.derklaro.reflexion.internal.handles.MethodHandleAccessorFactory;
import dev.derklaro.reflexion.internal.jna.JnaAccessorFactory;
import dev.derklaro.reflexion.internal.natives.NativeAccessorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ServiceLoader;
import lombok.NonNull;

public final class AccessorFactoryLoader {
    private static final AccessorFactory[] DEFAULT_FACTORIES = new AccessorFactory[]{new NativeAccessorFactory(), new JnaAccessorFactory(), new MethodHandleAccessorFactory(), new BareAccessorFactory()};

    private AccessorFactoryLoader() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static AccessorFactory doLoadFactory() {
        ClassLoader cl = AccessorFactoryLoader.class.getClassLoader();
        ServiceLoader<AccessorFactory> loader = ServiceLoader.load(AccessorFactory.class, cl);
        ArrayList<AccessorFactory> availableFactories = new ArrayList<AccessorFactory>();
        for (AccessorFactory factory : loader) {
            if (!factory.isAvailable()) continue;
            availableFactories.add(factory);
        }
        for (AccessorFactory factory : DEFAULT_FACTORIES) {
            if (!factory.isAvailable()) continue;
            availableFactories.add(factory);
        }
        if (availableFactories.isEmpty()) {
            throw new IllegalStateException("no accessor factory is available");
        }
        Collections.sort(availableFactories);
        return (AccessorFactory)availableFactories.get(0);
    }
}

