/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion;

import dev.derklaro.reflexion.internal.util.Exceptions;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class Result<S>
implements Supplier<S> {
    private final S result;
    private final Throwable exception;

    private Result(S result, Throwable exception) {
        this.result = result;
        this.exception = exception;
    }

    public static <T> Result<T> tryExecute(@NonNull ExceptionalSupplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        try {
            T result = supplier.get();
            return Result.success(result);
        }
        catch (Throwable exception) {
            Exceptions.rethrowIfFatal(exception);
            return Result.exceptional(exception);
        }
    }

    @NonNull
    public static <T> Result<T> success(@Nullable T result) {
        return new Result<T>(result, null);
    }

    @NonNull
    public static <T> Result<T> exceptional(@NonNull Throwable exception) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        return new Result<Object>(null, exception);
    }

    public boolean wasSuccessful() {
        return this.exception == null;
    }

    public boolean wasExceptional() {
        return this.exception != null;
    }

    @NonNull
    public Throwable getException() {
        if (this.exception != null) {
            return this.exception;
        }
        throw new NoSuchElementException("Unable to retrieve error on successful result!");
    }

    @Override
    public S get() {
        if (this.exception == null) {
            return this.result;
        }
        throw new NoSuchElementException("Unable to retrieve success result from exceptional result!");
    }

    public @UnknownNullability S getOrElse(@Nullable S or) {
        return this.exception == null ? this.result : or;
    }

    public @UnknownNullability S getOrEval(@NonNull Supplier<S> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        return this.exception == null ? this.result : supplier.get();
    }

    public @UnknownNullability S getOrMap(@NonNull Function<Throwable, S> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.exception == null ? this.result : function.apply(this.exception);
    }

    public @UnknownNullability S getOrThrow() {
        if (this.exception != null) {
            Exceptions.throwUnchecked(this.exception);
        }
        return this.result;
    }

    @NonNull
    public <M> Result<M> map(@NonNull Function<S, M> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (this.exception != null) {
            return this;
        }
        return Result.tryExecute(() -> function.apply(this.result));
    }

    @NonNull
    public <M> Result<M> flatMap(@NonNull Function<S, Result<M>> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (this.exception != null) {
            return this;
        }
        return function.apply(this.result);
    }

    @NonNull
    public Result<S> mapExceptional(@NonNull Function<Throwable, Throwable> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.exception == null ? this : Result.exceptional(function.apply(this.exception));
    }

    @NonNull
    public <M> Result<M> flatMapExceptional(@NonNull Function<Throwable, Result<M>> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (this.exception == null) {
            return this;
        }
        return function.apply(this.exception);
    }

    @NonNull
    public Result<S> ifSuccess(@NonNull Consumer<S> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (this.exception == null) {
            consumer.accept(this.result);
        }
        return this;
    }

    @NonNull
    public Result<S> ifExceptional(@NonNull Consumer<Throwable> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (this.exception != null) {
            consumer.accept(this.exception);
        }
        return this;
    }

    @NonNull
    public Result<S> consume(@NonNull BiConsumer<S, Throwable> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(this.result, this.exception);
        return this;
    }

    @NonNull
    public Optional<S> asOptional() {
        return Optional.ofNullable(this.result);
    }

    @FunctionalInterface
    public static interface ExceptionalSupplier<T> {
        @Nullable
        public T get() throws Throwable;
    }
}

