/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import lombok.NonNull;

final class ReflexionPopulator {
    private ReflexionPopulator() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static Set<Field> getAllFields(@NonNull Class<?> declaringClass) {
        if (declaringClass == null) {
            throw new NullPointerException("declaringClass is marked non-null but is null");
        }
        return ReflexionPopulator.mappingHierarchyTravel(declaringClass, Class::getDeclaredFields, Class::getFields);
    }

    @NonNull
    public static Set<Method> getAllMethods(@NonNull Class<?> declaringClass) {
        if (declaringClass == null) {
            throw new NullPointerException("declaringClass is marked non-null but is null");
        }
        return ReflexionPopulator.mappingHierarchyTravel(declaringClass, Class::getDeclaredMethods, Class::getMethods);
    }

    @NonNull
    public static Set<Constructor<?>> getAllConstructors(@NonNull Class<?> declaringClass) {
        if (declaringClass == null) {
            throw new NullPointerException("declaringClass is marked non-null but is null");
        }
        return ReflexionPopulator.mappingHierarchyTravel(declaringClass, Class::getDeclaredConstructors, Class::getConstructors);
    }

    @NonNull
    private static <T extends Member> Set<T> mappingHierarchyTravel(@NonNull Class<?> top, @NonNull Function<Class<?>, T[]> extractor, @NonNull Function<Class<?>, T[]> publicExtractor) {
        if (top == null) {
            throw new NullPointerException("top is marked non-null but is null");
        }
        if (extractor == null) {
            throw new NullPointerException("extractor is marked non-null but is null");
        }
        if (publicExtractor == null) {
            throw new NullPointerException("publicExtractor is marked non-null but is null");
        }
        LinkedHashSet<Member> target = new LinkedHashSet<Member>(Arrays.asList((Member[])publicExtractor.apply(top)));
        Class<?> current = top;
        do {
            Member[] privateValues;
            if ((privateValues = (Member[])extractor.apply(current)).length == 0) continue;
            if (privateValues.length == 1) {
                target.add(privateValues[0]);
                continue;
            }
            target.addAll(Arrays.asList(privateValues));
        } while ((current = current.getSuperclass()) != null);
        return target;
    }
}

