/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.reflexion;

import dev.derklaro.reflexion.AccessorFactory;
import dev.derklaro.reflexion.FieldAccessor;
import dev.derklaro.reflexion.MethodAccessor;
import dev.derklaro.reflexion.ReflexionException;
import dev.derklaro.reflexion.ReflexionPopulator;
import dev.derklaro.reflexion.internal.AccessorFactoryLoader;
import dev.derklaro.reflexion.internal.util.Util;
import dev.derklaro.reflexion.matcher.ConstructorMatcher;
import dev.derklaro.reflexion.matcher.FieldMatcher;
import dev.derklaro.reflexion.matcher.MethodMatcher;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class Reflexion {
    public static final AccessorFactory ACCESSOR_FACTORY = AccessorFactoryLoader.doLoadFactory();
    private final Class<?> wrappedClass;
    private final AccessorFactory accFactory;
    @Nullable
    private final Object binding;
    private Set<Field> fields;
    private Set<Method> methods;
    private Set<Constructor<?>> constructors;

    private Reflexion(@NonNull Class<?> wrappedClass, @Nullable Object binding, @NonNull AccessorFactory factory) {
        if (wrappedClass == null) {
            throw new NullPointerException("wrappedClass is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.wrappedClass = wrappedClass;
        this.binding = binding;
        this.accFactory = factory;
    }

    @NonNull
    public static Reflexion on(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return Reflexion.on(clazz, null);
    }

    @NonNull
    public static Reflexion on(@NonNull Object instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        return Reflexion.on(instance.getClass(), null);
    }

    @NonNull
    public static Reflexion onBound(@NonNull Object instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        return Reflexion.on(instance.getClass(), instance);
    }

    @NonNull
    public static Reflexion on(@NonNull Class<?> clazz, @Nullable Object binding) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return Reflexion.on(clazz, binding, ACCESSOR_FACTORY);
    }

    @NonNull
    public static Reflexion on(@NonNull Class<?> clazz, @Nullable Object binding, @NonNull AccessorFactory factory) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        return new Reflexion(clazz, binding, factory);
    }

    @NonNull
    public static Optional<Reflexion> find(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Reflexion.find(name, null);
    }

    @NonNull
    public static Optional<Reflexion> find(@NonNull String name, @Nullable ClassLoader loader) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        try {
            ClassLoader classLoader = Util.firstNonNull(loader, Thread.currentThread().getContextClassLoader(), Reflexion.class.getClassLoader(), ClassLoader.getSystemClassLoader());
            Class<?> wrappedClass = Class.forName(name, false, classLoader);
            return Optional.of(Reflexion.on(wrappedClass));
        }
        catch (ClassNotFoundException exception) {
            return Optional.empty();
        }
    }

    @NonNull
    public static Optional<Reflexion> findAny(String ... names) {
        if (names == null) {
            throw new NullPointerException("names is marked non-null but is null");
        }
        for (String name : names) {
            Optional<Reflexion> reflexion = Reflexion.find(name);
            if (!reflexion.isPresent()) continue;
            return reflexion;
        }
        return Optional.empty();
    }

    @NonNull
    public static Optional<Reflexion> findAny(@Nullable ClassLoader loader, String ... names) {
        if (names == null) {
            throw new NullPointerException("names is marked non-null but is null");
        }
        for (String name : names) {
            Optional<Reflexion> reflexion = Reflexion.find(name, loader);
            if (!reflexion.isPresent()) continue;
            return reflexion;
        }
        return Optional.empty();
    }

    @NonNull
    public static Reflexion get(@NonNull String name, @Nullable ClassLoader loader) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Reflexion.find(name, loader).orElseThrow(() -> new ReflexionException("No class with name " + name + " found"));
    }

    @NonNull
    public static Reflexion getAny(@Nullable ClassLoader loader, String ... names) {
        if (names == null) {
            throw new NullPointerException("names is marked non-null but is null");
        }
        return Reflexion.findAny(loader, names).orElseThrow(() -> {
            String fullNames = String.join((CharSequence)", ", names);
            return new ReflexionException("No class with any name of " + fullNames + " found");
        });
    }

    @NonNull
    public static FieldAccessor unreflectField(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return Reflexion.on(field.getDeclaringClass()).unreflect(field);
    }

    @NonNull
    public static MethodAccessor<Method> unreflectMethod(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return Reflexion.on(method.getDeclaringClass()).unreflect(method);
    }

    @NonNull
    public static MethodAccessor<Constructor<?>> unreflectConstructor(@NonNull Constructor<?> constructor) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        return Reflexion.on(constructor.getDeclaringClass()).unreflect(constructor);
    }

    @Contract(value="_ -> new", pure=true)
    @NonNull
    public Reflexion bind(@Nullable Object binding) {
        return new Reflexion(this.wrappedClass, binding, this.accFactory);
    }

    @NonNull
    public Class<?> getWrappedClass() {
        return this.wrappedClass;
    }

    @Nullable
    public Object getBinding() {
        return this.binding;
    }

    @NonNull
    public AccessorFactory getAccessorFactory() {
        return this.accFactory;
    }

    @NonNull
    public FieldAccessor unreflect(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.accFactory.wrapField(this, field);
    }

    @NonNull
    public MethodAccessor<Method> unreflect(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return this.accFactory.wrapMethod(this, method);
    }

    @NonNull
    public MethodAccessor<Constructor<?>> unreflect(@NonNull Constructor<?> constructor) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        return this.accFactory.wrapConstructor(this, constructor);
    }

    @NonNull
    public Optional<FieldAccessor> findField(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.findField((FieldMatcher)FieldMatcher.newMatcher().hasName(name));
    }

    @NonNull
    public Optional<FieldAccessor> findField(@NonNull FieldMatcher matcher) {
        if (matcher == null) {
            throw new NullPointerException("matcher is marked non-null but is null");
        }
        for (Field field : this.getFieldCache()) {
            if (!matcher.test(field)) continue;
            return Optional.of(this.accFactory.wrapField(this, field));
        }
        return Optional.empty();
    }

    @NonNull
    public Collection<FieldAccessor> findFields(@NonNull FieldMatcher matcher) {
        if (matcher == null) {
            throw new NullPointerException("matcher is marked non-null but is null");
        }
        return Util.filterAndMap(this.getFieldCache(), matcher, field -> this.accFactory.wrapField(this, (Field)field));
    }

    @NonNull
    public Optional<MethodAccessor<Method>> findMethod(@NonNull String name, Class<?> ... paramTypes) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (paramTypes == null) {
            throw new NullPointerException("paramTypes is marked non-null but is null");
        }
        return this.findMethod((MethodMatcher)((MethodMatcher)MethodMatcher.newMatcher().hasName(name)).exactTypes(Method::getParameterTypes, paramTypes));
    }

    @NonNull
    public Optional<MethodAccessor<Method>> findMethod(@NonNull MethodMatcher matcher) {
        if (matcher == null) {
            throw new NullPointerException("matcher is marked non-null but is null");
        }
        for (Method method : this.getMethodCache()) {
            if (!matcher.test(method)) continue;
            return Optional.of(this.accFactory.wrapMethod(this, method));
        }
        return Optional.empty();
    }

    @NonNull
    public Collection<MethodAccessor<Method>> findMethods(@NonNull MethodMatcher matcher) {
        if (matcher == null) {
            throw new NullPointerException("matcher is marked non-null but is null");
        }
        return Util.filterAndMap(this.getMethodCache(), matcher, method -> this.accFactory.wrapMethod(this, (Method)method));
    }

    @NonNull
    public Optional<MethodAccessor<Constructor<?>>> findConstructor(Class<?> ... paramTypes) {
        if (paramTypes == null) {
            throw new NullPointerException("paramTypes is marked non-null but is null");
        }
        return this.findConstructor((ConstructorMatcher)ConstructorMatcher.newMatcher().exactTypes(Constructor::getParameterTypes, paramTypes));
    }

    @NonNull
    public Optional<MethodAccessor<Constructor<?>>> findConstructor(@NonNull ConstructorMatcher matcher) {
        if (matcher == null) {
            throw new NullPointerException("matcher is marked non-null but is null");
        }
        for (Constructor<?> constructor : this.getConstructorCache()) {
            if (!matcher.test(constructor)) continue;
            return Optional.of(this.accFactory.wrapConstructor(this, constructor));
        }
        return Optional.empty();
    }

    @NonNull
    public Collection<MethodAccessor<Constructor<?>>> findConstructors(@NonNull ConstructorMatcher matcher) {
        if (matcher == null) {
            throw new NullPointerException("matcher is marked non-null but is null");
        }
        return Util.filterAndMap(this.getConstructorCache(), matcher, ctr -> this.accFactory.wrapConstructor(this, (Constructor<?>)ctr));
    }

    @NonNull
    private Set<Field> getFieldCache() {
        if (this.fields == null) {
            this.fields = ReflexionPopulator.getAllFields(this.wrappedClass);
        }
        return this.fields;
    }

    @NonNull
    private Set<Method> getMethodCache() {
        if (this.methods == null) {
            this.methods = ReflexionPopulator.getAllMethods(this.wrappedClass);
        }
        return this.methods;
    }

    @NonNull
    private Set<Constructor<?>> getConstructorCache() {
        if (this.constructors == null) {
            this.constructors = ReflexionPopulator.getAllConstructors(this.wrappedClass);
        }
        return this.constructors;
    }
}

