/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.util;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.ElementMatcher;
import dev.derklaro.aerogel.InjectionContext;
import dev.derklaro.aerogel.KnownValue;
import dev.derklaro.aerogel.ScopeProvider;
import dev.derklaro.aerogel.internal.provider.BaseContextualProvider;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.STABLE, since="2.0")
public final class Scopes {
    public static final ScopeProvider SINGLETON = SingletonContextualProvider::new;

    private Scopes() {
        throw new UnsupportedOperationException();
    }

    @API(status=API.Status.INTERNAL, since="2.0")
    private static final class SingletonContextualProvider
    extends BaseContextualProvider<Object> {
        private final ContextualProvider<Object> downstream;
        private final AtomicReference<KnownValue> reference = new AtomicReference();

        public SingletonContextualProvider(@NotNull Type constructingType, @NotNull ElementMatcher elementMatcher, @NotNull ContextualProvider<Object> downstream) {
            super(downstream.injector(), constructingType, elementMatcher);
            this.downstream = downstream;
        }

        @Override
        @Nullable
        public Object get(@NotNull InjectionContext context) throws AerogelException {
            KnownValue knownValue = this.reference.get();
            if (knownValue != null) {
                return knownValue;
            }
            Object value = this.downstream.get(context);
            KnownValue firstOccurrence = KnownValue.of(value);
            if (this.reference.compareAndSet(null, firstOccurrence.asSecondOccurrence())) {
                return firstOccurrence;
            }
            knownValue = this.reference.get();
            return knownValue;
        }
    }
}

