/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.member;

import java.util.EnumSet;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.STABLE, since="2.0")
public enum InjectionSetting {
    PRIVATE_METHODS,
    STATIC_METHODS,
    INSTANCE_METHODS,
    INHERITED_METHODS,
    PRIVATE_FIELDS,
    STATIC_FIELDS,
    INSTANCE_FIELDS,
    INHERITED_FIELDS,
    ONLY_UNINITIALIZED_FIELDS,
    RUN_POST_CONSTRUCT_LISTENERS;

    public static final long FLAG_STATIC_MEMBERS;
    public static final long FLAG_ALL_MEMBERS;
    private static final InjectionSetting[] VALUES;
    private final long raw = 1L << this.ordinal();

    public static long toFlag(InjectionSetting ... injectionSettings) {
        long raw = 0L;
        for (InjectionSetting injectionSetting : injectionSettings) {
            raw |= injectionSetting.raw;
        }
        return raw;
    }

    @NotNull
    public static EnumSet<InjectionSetting> fromFlags(long flags) {
        EnumSet<InjectionSetting> injectionSettings = EnumSet.noneOf(InjectionSetting.class);
        if (flags == 0L) {
            return injectionSettings;
        }
        for (InjectionSetting value : VALUES) {
            if (!value.enabled(flags)) continue;
            injectionSettings.add(value);
        }
        return injectionSettings;
    }

    public boolean enabled(long flags) {
        return (flags & this.raw) == this.raw;
    }

    public boolean disabled(long flags) {
        return (flags & this.raw) == 0L;
    }

    static {
        FLAG_STATIC_MEMBERS = InjectionSetting.toFlag(PRIVATE_FIELDS, PRIVATE_METHODS, STATIC_FIELDS, STATIC_METHODS, INHERITED_FIELDS, INHERITED_METHODS);
        FLAG_ALL_MEMBERS = InjectionSetting.toFlag(PRIVATE_METHODS, STATIC_METHODS, INSTANCE_METHODS, INHERITED_METHODS, PRIVATE_FIELDS, STATIC_FIELDS, INSTANCE_FIELDS, INHERITED_FIELDS, RUN_POST_CONSTRUCT_LISTENERS);
        VALUES = InjectionSetting.values();
    }
}

