/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.util;

import dev.derklaro.aerogel.internal.reflect.TypeUtil;
import java.util.Collection;
import java.util.StringJoiner;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel"})
public final class ToStringHelper {
    private final String prefix;
    private final StringJoiner stringJoiner;

    private ToStringHelper(@NotNull Object instance) {
        this.prefix = TypeUtil.toPrettyString(instance.getClass());
        this.stringJoiner = new StringJoiner(", ", "(", ")");
    }

    @NotNull
    public static ToStringHelper create(@NotNull Object instance) {
        return new ToStringHelper(instance);
    }

    @NotNull
    public ToStringHelper putCollection(@NotNull String name, @Nullable Collection<?> value) {
        if (value == null || value.isEmpty()) {
            return this.putField(name, "[]");
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (Object entry : value) {
            if (entry == null) continue;
            joiner.add(entry.toString());
        }
        return this.putField(name, joiner.toString());
    }

    @NotNull
    public ToStringHelper putField(@NotNull String name, @Nullable Object value) {
        String toStringValue = String.format("%s=%s", name, value);
        this.stringJoiner.add(toStringValue);
        return this;
    }

    @NotNull
    public String toString() {
        return this.prefix + this.stringJoiner.toString();
    }
}

