/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.util;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.internal.unsafe.UnsafeMemberAccess;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.*"})
public final class MethodHandleUtil {
    private static final MethodHandles.Lookup BASE_LOOKUP = MethodHandles.lookup();

    private MethodHandleUtil() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static Object invokeMethod(@NotNull MethodHandle handle, @Nullable Object instance, @NotNull Object[] params) throws Throwable {
        return params.length == 0 ? handle.invoke(instance) : handle.invoke(instance, params);
    }

    @Nullable
    public static Object invokeConstructor(@NotNull MethodHandle handle, @NotNull Object[] params) throws Throwable {
        return params.length == 0 ? handle.invoke() : handle.invoke(params);
    }

    @NotNull
    public static MethodHandle toGenericMethodHandle(@NotNull Method method) {
        try {
            Method accessible = UnsafeMemberAccess.makeAccessible(method);
            MethodHandle directHandle = BASE_LOOKUP.unreflect(accessible);
            MethodHandle targetHandle = directHandle.asFixedArity();
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            int paramCount = targetHandle.type().parameterCount() - (isStatic ? 0 : 1);
            MethodType type = MethodType.genericMethodType(1, paramCount > 0);
            if (paramCount > 0) {
                targetHandle = targetHandle.asSpreader(Object[].class, paramCount);
            }
            if (isStatic) {
                targetHandle = MethodHandles.dropArguments(targetHandle, 0, new Class[]{Object.class});
            }
            return targetHandle.asType(type);
        }
        catch (IllegalAccessException exception) {
            throw AerogelException.forMessagedException("Unable to unreflect method " + method.getName(), exception);
        }
    }

    @NotNull
    public static MethodHandle toGenericMethodHandle(@NotNull Constructor<?> constructor) {
        try {
            Constructor<?> accessible = UnsafeMemberAccess.makeAccessible(constructor);
            MethodHandle directHandle = BASE_LOOKUP.unreflectConstructor(accessible);
            MethodHandle targetHandle = directHandle.asFixedArity();
            int paramCount = directHandle.type().parameterCount();
            MethodType type = MethodType.genericMethodType(0, paramCount > 0);
            if (paramCount > 0) {
                targetHandle = targetHandle.asSpreader(Object[].class, paramCount);
            }
            return targetHandle.asType(type);
        }
        catch (IllegalAccessException exception) {
            throw AerogelException.forMessagedException("Unable to unreflect constructor " + constructor, exception);
        }
    }

    @NotNull
    public static MethodHandle toGenericGetterMethodHandle(@NotNull Field field) {
        try {
            Field accessible = UnsafeMemberAccess.makeAccessible(field);
            MethodHandle directHandle = BASE_LOOKUP.unreflectGetter(accessible);
            MethodHandle targetHandle = directHandle.asFixedArity();
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            MethodType type = isStatic ? MethodType.methodType(Object.class) : MethodType.methodType(Object.class, Object.class);
            return targetHandle.asType(type);
        }
        catch (IllegalAccessException exception) {
            throw AerogelException.forMessagedException("Unable to unreflect getter for field " + field.getName(), exception);
        }
    }

    @NotNull
    public static MethodHandle toGenericSetterMethodHandle(@NotNull Field field) {
        try {
            Field accessible = UnsafeMemberAccess.makeAccessible(field);
            MethodHandle directHandle = BASE_LOOKUP.unreflectSetter(accessible);
            MethodHandle targetHandle = directHandle.asFixedArity();
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            MethodType type = isStatic ? MethodType.methodType(Void.TYPE, Object.class) : MethodType.methodType(Void.TYPE, Object.class, Object.class);
            return targetHandle.asType(type);
        }
        catch (IllegalAccessException exception) {
            throw AerogelException.forMessagedException("Unable to unreflect getter for field " + field.getName(), exception);
        }
    }
}

