/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.util;

import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.ProvidedBy;
import dev.derklaro.aerogel.binding.BindingBuilder;
import dev.derklaro.aerogel.binding.BindingConstructor;
import dev.derklaro.aerogel.binding.BindingHolder;
import dev.derklaro.aerogel.internal.reflect.TypeUtil;
import dev.derklaro.aerogel.util.Scopes;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel"})
public final class InjectorUtil {
    public static final Element INJECTOR_ELEMENT = Element.forType(Injector.class);
    public static final BindingConstructor INJECTOR_BINDING_CONSTRUCTOR = BindingBuilder.create().bind(INJECTOR_ELEMENT).scoped(Scopes.SINGLETON).toLazyInstance(injector -> injector);

    private InjectorUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Supplier<BindingHolder> createJITBindingFactory(@NotNull Injector injector, @NotNull Element element) {
        return () -> {
            Class<?> rawType = TypeUtil.rawType(element.componentType());
            ProvidedBy providedBy = rawType.getDeclaredAnnotation(ProvidedBy.class);
            if (providedBy != null) {
                return BindingBuilder.create().bindFully(element).toConstructing(providedBy.value()).construct(injector);
            }
            return BindingBuilder.create().bindFully(element).toConstructing(rawType).construct(injector);
        };
    }
}

