/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.util;

import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.internal.jakarta.JakartaBridge;
import dev.derklaro.aerogel.internal.reflect.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel"})
public final class ElementHelper {
    private ElementHelper() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Element buildElement(@NotNull Field field, Annotation[] ... annotations) {
        return ElementHelper.buildElement(field.getGenericType(), field.getType(), annotations);
    }

    @NotNull
    public static Element buildElement(@NotNull Parameter parameter, Annotation[] ... annotations) {
        return ElementHelper.buildElement(parameter.getParameterizedType(), parameter.getType(), annotations);
    }

    @NotNull
    public static Element buildElement(@NotNull Method method, Annotation[] ... annotations) {
        return ElementHelper.buildElement(method.getGenericReturnType(), method.getReturnType(), annotations);
    }

    @NotNull
    public static Element buildElement(@NotNull Type fullType, @NotNull Class<?> rawType) {
        return ElementHelper.buildElement(fullType, rawType, (Annotation[][])new Annotation[][]{rawType.getDeclaredAnnotations()});
    }

    @NotNull
    private static Element buildElement(@NotNull Type fullType, @NotNull Class<?> rawType, Annotation[] ... annotations) {
        Type type = JakartaBridge.isProvider(rawType) ? ReflectionUtil.genericSuperType(fullType) : fullType;
        Element element = Element.forType(type);
        LinkedList<Annotation> qualifiers = new LinkedList<Annotation>();
        for (Annotation[] annotation : annotations) {
            JakartaBridge.translateQualifierAnnotations(annotation);
            qualifiers.addAll(ElementHelper.extractQualifierAnnotations(annotation));
        }
        for (Annotation annotation : qualifiers) {
            element = element.requireAnnotation(annotation);
        }
        return element;
    }

    public static Collection<Annotation> extractQualifierAnnotations(@NotNull Annotation[] annotations) {
        LinkedList<Annotation> qualifiedAnnotations = new LinkedList<Annotation>();
        for (Annotation annotation : annotations) {
            if (!JakartaBridge.isQualifierAnnotation(annotation)) continue;
            qualifiedAnnotations.add(annotation);
        }
        return qualifiedAnnotations;
    }
}

