/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.unsafe;

import dev.derklaro.aerogel.internal.unsafe.UnsafeAccess;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel.internal"})
public final class UnsafeMemberAccess {
    private static final Object SOME_OBJECT = new Object();
    private static final long OVERRIDE_BOOLEAN_OFFSET;

    private UnsafeMemberAccess() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static <T extends AccessibleObject> T makeAccessible(@NotNull T accessibleObject) {
        UnsafeMemberAccess.makeAccessible(accessibleObject, false);
        return accessibleObject;
    }

    @NotNull
    public static <T extends AccessibleObject> T forceMakeAccessible(@NotNull T accessibleObject) {
        UnsafeMemberAccess.makeAccessible(accessibleObject, true);
        return accessibleObject;
    }

    private static void makeAccessible(@NotNull AccessibleObject accessibleObject, boolean ensure) {
        block5: {
            if (accessibleObject.isAccessible()) {
                return;
            }
            if (OVERRIDE_BOOLEAN_OFFSET != -1L) {
                UnsafeAccess.U.putByte(accessibleObject, OVERRIDE_BOOLEAN_OFFSET, (byte)1);
            } else {
                try {
                    accessibleObject.setAccessible(true);
                }
                catch (Exception exception) {
                    if (!ensure) break block5;
                    throw exception;
                }
            }
        }
    }

    static {
        long overrideBooleanOff = -1L;
        if (UnsafeAccess.isAvailable()) {
            try {
                Field inaccessibleField = UnsafeMemberAccess.class.getDeclaredField("SOME_OBJECT");
                Field accessibleField = UnsafeMemberAccess.class.getDeclaredField("SOME_OBJECT");
                accessibleField.setAccessible(true);
                for (long off = 8L; off < 128L; ++off) {
                    byte accessible = UnsafeAccess.U.getByte(accessibleField, off);
                    byte inaccessible = UnsafeAccess.U.getByte(inaccessibleField, off);
                    if (accessible != 1 || inaccessible != 0) continue;
                    UnsafeAccess.U.putByte(inaccessibleField, off, (byte)1);
                    if (inaccessibleField.isAccessible()) {
                        overrideBooleanOff = off;
                        break;
                    }
                    UnsafeAccess.U.putByte(inaccessibleField, off, (byte)0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OVERRIDE_BOOLEAN_OFFSET = overrideBooleanOff;
    }
}

