/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.reflect;

import dev.derklaro.aerogel.AerogelException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.StringJoiner;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.*"})
public final class TypeUtil {
    private TypeUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Class<?> rawType(@NotNull Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            Class<?> componentType = TypeUtil.rawType(((GenericArrayType)type).getGenericComponentType());
            return Array.newInstance(componentType, 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            return TypeUtil.rawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type[] bounds = typeVariable.getBounds();
            return bounds.length == 0 ? Object.class : TypeUtil.rawType(bounds[0]);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] lowerBounds = wildcardType.getLowerBounds();
            return TypeUtil.rawType(lowerBounds.length > 0 ? lowerBounds[0] : wildcardType.getUpperBounds()[0]);
        }
        throw AerogelException.forMessage("Unsupported type " + type + " to erase");
    }

    @NotNull
    public static String toPrettyString(@NotNull Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            Class<?> enclosingClass = clazz.getEnclosingClass();
            if (enclosingClass != null) {
                String prettyEnclosingClass = TypeUtil.toPrettyString(enclosingClass);
                return prettyEnclosingClass + '$' + clazz.getSimpleName();
            }
            return clazz.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            StringBuilder infoBuilder = new StringBuilder();
            ParameterizedType parameterizedType = (ParameterizedType)type;
            String rawPretty = TypeUtil.toPrettyString(parameterizedType.getRawType());
            infoBuilder.append(rawPretty);
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (typeArguments.length > 0) {
                StringJoiner argumentJoiner = new StringJoiner(", ", "<", ">");
                for (Type typeArgument : typeArguments) {
                    String argumentPretty = TypeUtil.toPrettyString(typeArgument);
                    argumentJoiner.add(argumentPretty);
                }
                infoBuilder.append(argumentJoiner);
            }
            return infoBuilder.toString();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] lowerBounds = wildcardType.getLowerBounds();
            if (lowerBounds.length > 0) {
                String prettyBound = TypeUtil.toPrettyString(lowerBounds[0]);
                return "? super " + prettyBound;
            }
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds.length == 0 || upperBounds[0] == Object.class) {
                return "?";
            }
            String prettyBound = TypeUtil.toPrettyString(upperBounds[0]);
            return "? extends " + prettyBound;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            String prettyComponentType = TypeUtil.toPrettyString(genericArrayType.getGenericComponentType());
            return prettyComponentType + "[]";
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type[] bounds = typeVariable.getBounds();
            String prettyBound = TypeUtil.toPrettyString(bounds.length == 0 ? Object.class : bounds[0]);
            return prettyBound + " " + typeVariable.getName();
        }
        return type.toString();
    }
}

