/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.reflect;

import dev.derklaro.aerogel.internal.reflect.Primitives;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel.internal.*"})
public final class ReflectionUtil {
    private ReflectionUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Type genericSuperType(@NotNull Type type) {
        return type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : type;
    }

    public static int signatureHashCode(@NotNull Method method) {
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        int hash = methodName.hashCode();
        for (Class<?> paramType : paramTypes) {
            hash = hash * 31 + paramType.hashCode();
        }
        return hash;
    }

    public static boolean overrides(@NotNull Method left, @NotNull Method right) {
        int modifiers = left.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers)) {
            return true;
        }
        return Objects.equals(left.getDeclaringClass().getPackage(), right.getDeclaringClass().getPackage());
    }

    public static boolean isUninitialized(@NotNull Field field, @Nullable Object holder) throws IllegalAccessException {
        Object currentValue = field.get(holder);
        if (ReflectionUtil.isPrimitive(field.getGenericType())) {
            return currentValue != null && currentValue.equals(Primitives.defaultValue(field.getType()));
        }
        return currentValue == null;
    }

    public static boolean isPrimitive(@NotNull Type type) {
        return type instanceof Class && ((Class)type).isPrimitive();
    }

    @NotNull
    public static List<Class<?>> hierarchyTree(@NotNull Class<?> startingPoint) {
        LinkedList result = new LinkedList();
        Class<?> currentClass = startingPoint;
        while (currentClass != null) {
            result.add(currentClass);
            if ((currentClass = currentClass.getSuperclass()) != Object.class) continue;
        }
        return result;
    }
}

