/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.reflect"})
final class RecordSupport {
    private static final MethodHandle GET_RECORD_COMPONENTS;
    private static final MethodHandle RECORD_COMPONENT_GET_TYPE;

    RecordSupport() {
    }

    public static boolean available() {
        return GET_RECORD_COMPONENTS != null && RECORD_COMPONENT_GET_TYPE != null;
    }

    @Nullable
    public static Class<?>[] recordComponentTypes(@NotNull Class<?> clazz) {
        try {
            Object[] recordComponents = GET_RECORD_COMPONENTS.invoke(clazz);
            if (recordComponents == null) {
                return null;
            }
            Class[] types = new Class[recordComponents.length];
            for (int i = 0; i < recordComponents.length; ++i) {
                Class type;
                types[i] = type = RECORD_COMPONENT_GET_TYPE.invoke(recordComponents[i]);
            }
            return types;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static {
        MethodHandle recordComponentGetType;
        MethodHandle getRecordComponents;
        try {
            Method getRecordComponentsMethod = Class.class.getMethod("getRecordComponents", new Class[0]);
            Class<?> recordComponentType = getRecordComponentsMethod.getReturnType().getComponentType();
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            getRecordComponents = lookup.unreflect(getRecordComponentsMethod);
            recordComponentGetType = lookup.findVirtual(recordComponentType, "getType", MethodType.methodType(Class.class));
        }
        catch (IllegalAccessException | NoSuchMethodException exception) {
            getRecordComponents = null;
            recordComponentGetType = null;
        }
        GET_RECORD_COMPONENTS = getRecordComponents;
        RECORD_COMPONENT_GET_TYPE = recordComponentGetType;
    }
}

