/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.reflect;

import dev.derklaro.aerogel.internal.util.Preconditions;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel.internal"})
public final class Primitives {
    private static final Float FLOAT_DEFAULT = Float.valueOf(0.0f);
    private static final Double DOUBLE_DEFAULT = 0.0;

    private Primitives() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static <T> T defaultValue(@NotNull Class<T> type) {
        Preconditions.checkArgument(type.isPrimitive(), "type " + type + " is not primitive");
        if (type == Boolean.TYPE) {
            return (T)Boolean.FALSE;
        }
        if (type == Character.TYPE) {
            return (T)Character.valueOf('\u0000');
        }
        if (type == Byte.TYPE) {
            return (T)Byte.valueOf((byte)0);
        }
        if (type == Short.TYPE) {
            return (T)Short.valueOf((short)0);
        }
        if (type == Integer.TYPE) {
            return (T)Integer.valueOf(0);
        }
        if (type == Long.TYPE) {
            return (T)Long.valueOf(0L);
        }
        if (type == Float.TYPE) {
            return (T)FLOAT_DEFAULT;
        }
        if (type == Double.TYPE) {
            return (T)DOUBLE_DEFAULT;
        }
        throw new AssertionError();
    }
}

