/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.reflect;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.internal.jakarta.JakartaBridge;
import dev.derklaro.aerogel.internal.reflect.RecordSupport;
import java.lang.reflect.Constructor;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel.internal"})
public final class InjectionClassLookup {
    private InjectionClassLookup() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Constructor<?> findInjectableConstructor(@NotNull Class<?> clazz) {
        Class<?>[] recordComponentTypes;
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Constructor<?> injectionPoint = null;
        for (Constructor<?> constructor : constructors) {
            if (!JakartaBridge.isInjectable(constructor)) continue;
            if (injectionPoint != null) {
                throw AerogelException.forMessage("Class " + clazz.getName() + " declared multiple constructors which are annotated as @Inject.");
            }
            injectionPoint = constructor;
        }
        if (injectionPoint == null && RecordSupport.available() && (recordComponentTypes = RecordSupport.recordComponentTypes(clazz)) != null) {
            try {
                injectionPoint = clazz.getDeclaredConstructor(recordComponentTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (injectionPoint == null) {
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterCount() != 0) continue;
                injectionPoint = constructor;
                break;
            }
        }
        if (injectionPoint == null) {
            throw AerogelException.forMessage("No injectable constructor in class " + clazz.getName());
        }
        return injectionPoint;
    }
}

