/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.proxy;

import dev.derklaro.aerogel.internal.proxy.DelegationHolder;
import dev.derklaro.aerogel.internal.proxy.InjectionTimeProxy;
import dev.derklaro.aerogel.internal.util.NullMask;
import dev.derklaro.aerogel.internal.util.Preconditions;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.*"})
public final class ProxyMapping
implements DelegationHolder {
    private final Object proxy;
    private final InjectionTimeProxy.DelegatingInvocationHandler invocationHandler;

    public ProxyMapping(@NotNull Object proxy, @NotNull InjectionTimeProxy.DelegatingInvocationHandler handler) {
        this.proxy = proxy;
        this.invocationHandler = handler;
    }

    @NotNull
    public Object proxy() {
        return this.proxy;
    }

    @Override
    public void setDelegate(@Nullable Object delegate) {
        Preconditions.checkArgument(this.invocationHandler.delegate == null, "delegate already set");
        this.invocationHandler.delegate = NullMask.mask(delegate);
    }

    @Override
    public boolean isDelegatePresent() {
        return this.invocationHandler.delegate != null;
    }
}

