/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.proxy;

import dev.derklaro.aerogel.internal.proxy.ProxyMapping;
import dev.derklaro.aerogel.internal.unsafe.UnsafeMemberAccess;
import dev.derklaro.aerogel.internal.util.NullMask;
import dev.derklaro.aerogel.internal.util.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel.internal"})
public final class InjectionTimeProxy {
    private InjectionTimeProxy() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static <T> ProxyMapping makeProxy(@NotNull Class<T> interfaceClass) {
        DelegatingInvocationHandler handler = new DelegatingInvocationHandler();
        Object proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)handler);
        return new ProxyMapping(proxy, handler);
    }

    public static boolean isProxy(@NotNull Object candidate) {
        return Proxy.isProxyClass(candidate.getClass());
    }

    @API(status=API.Status.INTERNAL, since="2.0")
    static final class DelegatingInvocationHandler
    implements InvocationHandler {
        Object delegate;

        DelegatingInvocationHandler() {
        }

        @Override
        @Nullable
        public Object invoke(@NotNull Object proxy, @NotNull Method method, @NotNull Object[] args) throws Throwable {
            Object delegate = this.delegate;
            Preconditions.checkArgument(delegate != null, "Proxy was used before a delegate is available");
            Method accessibleMethod = UnsafeMemberAccess.forceMakeAccessible(method);
            try {
                Object unmaskedDelegate = NullMask.unmask(delegate);
                return accessibleMethod.invoke(unmaskedDelegate, args);
            }
            catch (InvocationTargetException invocationException) {
                throw invocationException.getTargetException();
            }
        }
    }
}

