/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.provider;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.ElementMatcher;
import dev.derklaro.aerogel.InjectionContext;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.internal.context.util.ContextInstanceResolveHelper;
import java.lang.reflect.Type;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.*"})
public abstract class BaseContextualProvider<T>
implements ContextualProvider<T> {
    protected final Injector injector;
    protected final Type constructingType;
    protected final ElementMatcher elementMatcher;

    protected BaseContextualProvider(@NotNull Injector injector, @NotNull Type constructingType, @NotNull ElementMatcher elementMatcher) {
        this.injector = injector;
        this.constructingType = constructingType;
        this.elementMatcher = elementMatcher;
    }

    @Override
    @NotNull
    public Injector injector() {
        return this.injector;
    }

    @Override
    @NotNull
    public Type constructingType() {
        return this.constructingType;
    }

    @Override
    @NotNull
    public ElementMatcher elementMatcher() {
        return this.elementMatcher;
    }

    @Override
    @NotNull
    public InjectionContext.Builder createContextBuilder() {
        return InjectionContext.builder(this.constructingType, this);
    }

    @Override
    @Nullable
    public T get() throws AerogelException {
        return (T)ContextInstanceResolveHelper.resolveInstance(this.constructingType, this);
    }
}

