/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.member;

import dev.derklaro.aerogel.PostConstruct;
import dev.derklaro.aerogel.internal.jakarta.JakartaBridge;
import dev.derklaro.aerogel.internal.reflect.ReflectionUtil;
import dev.derklaro.aerogel.internal.unsafe.UnsafeMemberAccess;
import dev.derklaro.aerogel.internal.util.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.member"})
final class MemberTree {
    private final Class<?> baseType;
    private final List<Field> injectableFields = new LinkedList<Field>();
    private final List<Method> injectableMethods = new LinkedList<Method>();
    private final List<Method> postConstructMethods = new LinkedList<Method>();

    public MemberTree(@NotNull Class<?> baseType) {
        this.baseType = baseType;
    }

    public void buildTree() {
        int startIndex;
        List<Class<?>> hierarchyTree = ReflectionUtil.hierarchyTree(this.baseType);
        for (int i = startIndex = hierarchyTree.size() - 1; i >= 0; --i) {
            Method[] methods;
            Field[] fields;
            Class<?> currentType = hierarchyTree.get(i);
            for (Field field : fields = currentType.getDeclaredFields()) {
                Field accessible;
                if (!JakartaBridge.isInjectable(field) || !(accessible = UnsafeMemberAccess.makeAccessible(field)).isAccessible()) continue;
                this.injectableFields.add(accessible);
            }
            for (Method method : methods = currentType.getDeclaredMethods()) {
                if (Modifier.isAbstract(method.getModifiers()) || Modifier.isNative(method.getModifiers())) continue;
                if (JakartaBridge.isInjectable(method)) {
                    Method accessible = UnsafeMemberAccess.makeAccessible(method);
                    if (!accessible.isAccessible()) continue;
                    if (Modifier.isStatic(method.getModifiers())) {
                        this.injectableMethods.add(accessible);
                        continue;
                    }
                    this.replaceOrRegisterMethod(this.injectableMethods, method, false);
                    continue;
                }
                this.replaceOrRegisterMethod(this.injectableMethods, method, true);
                boolean postConstructListener = method.isAnnotationPresent(PostConstruct.class);
                if (postConstructListener) {
                    Preconditions.checkArgument(method.getParameterCount() == 0, "@PostConstruct takes arguments");
                    Preconditions.checkArgument(!Modifier.isStatic(method.getModifiers()), "@PostConstruct method is static");
                    this.replaceOrRegisterMethod(this.postConstructMethods, method, false);
                    continue;
                }
                this.replaceOrRegisterMethod(this.postConstructMethods, method, true);
            }
        }
    }

    private void replaceOrRegisterMethod(@NotNull List<Method> knownMethods, @NotNull Method method, boolean unregister) {
        int methodSignatureHash = ReflectionUtil.signatureHashCode(method);
        for (int i = 0; i < knownMethods.size(); ++i) {
            boolean overridden;
            Method knownMethod = knownMethods.get(i);
            int knownMethodSignatureHash = ReflectionUtil.signatureHashCode(knownMethod);
            if (knownMethodSignatureHash != methodSignatureHash || !(overridden = ReflectionUtil.overrides(method, knownMethod))) continue;
            if (unregister) {
                knownMethods.remove(knownMethod);
            } else {
                knownMethods.set(i, method);
            }
            return;
        }
        if (!unregister) {
            knownMethods.add(method);
        }
    }

    @NotNull
    public List<Field> injectableFields() {
        return this.injectableFields;
    }

    @NotNull
    public List<Method> injectableMethods() {
        return this.injectableMethods;
    }

    @NotNull
    public List<Method> postConstructMethods() {
        return this.postConstructMethods;
    }
}

