/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.member;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.Order;
import dev.derklaro.aerogel.internal.jakarta.JakartaBridge;
import dev.derklaro.aerogel.internal.member.MemberTree;
import dev.derklaro.aerogel.internal.reflect.ReflectionUtil;
import dev.derklaro.aerogel.internal.util.ElementHelper;
import dev.derklaro.aerogel.internal.util.MethodHandleUtil;
import dev.derklaro.aerogel.internal.util.Preconditions;
import dev.derklaro.aerogel.member.InjectionSetting;
import dev.derklaro.aerogel.member.MemberInjector;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel.internal"})
public final class DefaultMemberInjector
implements MemberInjector {
    private static final Object[] NO_PARAMS = new Object[0];
    private final Injector injector;
    private final Class<?> targetClass;
    private final Predicate<Member> memberInTargetClass;
    private final Predicate<Member> memberInInheritedClass;
    private final List<InjectableField> injectableFields;
    private final List<InjectableMethod> injectableMethods;
    private final List<InjectableMethod> postConstructMethods;

    public DefaultMemberInjector(@NotNull Injector injector, @NotNull Class<?> target) {
        this.injector = injector;
        this.targetClass = target;
        MemberTree memberTree = new MemberTree(target);
        memberTree.buildTree();
        this.injectableFields = memberTree.injectableFields().stream().map(InjectableField::new).collect(Collectors.toCollection(LinkedList::new));
        this.injectableMethods = memberTree.injectableMethods().stream().map(InjectableMethod::new).sorted().collect(Collectors.toCollection(LinkedList::new));
        this.postConstructMethods = memberTree.postConstructMethods().stream().map(InjectableMethod::new).sorted().collect(Collectors.toCollection(LinkedList::new));
        this.memberInTargetClass = member -> member.getDeclaringClass() == this.targetClass;
        this.memberInInheritedClass = member -> member.getDeclaringClass() != this.targetClass;
    }

    @Override
    @NotNull
    public Injector injector() {
        return this.injector;
    }

    @Override
    @NotNull
    public Class<?> targetClass() {
        return this.targetClass;
    }

    @Override
    public void inject() {
        this.inject(InjectionSetting.FLAG_STATIC_MEMBERS);
    }

    @Override
    public void inject(long flags) {
        this.inject(null, flags);
    }

    @Override
    public void inject(@Nullable Object instance) {
        this.inject(instance, InjectionSetting.FLAG_ALL_MEMBERS);
    }

    @Override
    public void inject(@Nullable Object instance, long flags) {
        this.injectStaticFields(this.memberInInheritedClass, flags);
        this.injectStaticMethods(this.memberInInheritedClass, flags);
        this.injectStaticFields(this.memberInTargetClass, flags);
        this.injectStaticMethods(this.memberInTargetClass, flags);
        this.injectInstanceFields(instance, this.memberInInheritedClass, flags);
        this.injectInstanceMethods(instance, this.memberInInheritedClass, flags);
        this.injectInstanceFields(instance, this.memberInTargetClass, flags);
        this.injectInstanceMethods(instance, this.memberInTargetClass, flags);
        this.executePostConstructListeners(instance, flags);
    }

    @Override
    public void injectField(@NotNull String name) {
        for (InjectableField injectable : this.injectableFields) {
            if (!injectable.field.getName().equals(name)) continue;
            this.injectField(null, injectable);
            return;
        }
        throw AerogelException.forMessage(String.format("No static field with name %s in %s", name, this.targetClass));
    }

    @Override
    public void injectField(@Nullable Object instance, @NotNull String name) {
        for (InjectableField injectable : this.injectableFields) {
            if (!injectable.field.getName().equals(name)) continue;
            this.injectField(instance, injectable);
            return;
        }
        throw AerogelException.forMessage(String.format("No field with name %s in %s", name, this.targetClass));
    }

    @Override
    @Nullable
    public Object injectMethod(@NotNull String name, Class<?> ... parameterTypes) {
        for (InjectableMethod injectable : this.injectableMethods) {
            if (!injectable.method.getName().equals(name) || !Arrays.equals(injectable.parameterTypes, parameterTypes)) continue;
            return this.injectMethod(null, injectable);
        }
        throw AerogelException.forMessage(String.format("No static method with name %s and parameters %s in %s", name, Arrays.toString(parameterTypes), this.targetClass));
    }

    @Override
    @Nullable
    public Object injectMethod(@Nullable Object instance, @NotNull String name, Class<?> ... params) {
        for (InjectableMethod injectable : this.injectableMethods) {
            if (!injectable.method.getName().equals(name) || !Arrays.equals(injectable.parameterTypes, params)) continue;
            return this.injectMethod(instance, injectable);
        }
        throw AerogelException.forMessage(String.format("No method with name %s and parameters %s in %s", name, Arrays.toString(params), this.targetClass));
    }

    private void injectStaticFields(@NotNull Predicate<Member> preTester, long flags) {
        if (InjectionSetting.STATIC_FIELDS.enabled(flags)) {
            for (InjectableField field : this.injectableFields) {
                if (!Modifier.isStatic(field.field.getModifiers()) || !preTester.test(field.field) || !this.fieldMatches(field.field, null, flags)) continue;
                this.injectField(null, field);
            }
        }
    }

    private void injectInstanceFields(@Nullable Object instance, @NotNull Predicate<Member> preTester, long flags) {
        if (InjectionSetting.INSTANCE_FIELDS.enabled(flags)) {
            for (InjectableField injectable : this.injectableFields) {
                if (Modifier.isStatic(injectable.field.getModifiers()) || !preTester.test(injectable.field) || !this.fieldMatches(injectable.field, instance, flags)) continue;
                this.injectField(instance, injectable);
            }
        }
    }

    private void injectStaticMethods(@NotNull Predicate<Member> preTester, long flags) {
        if (InjectionSetting.STATIC_METHODS.enabled(flags)) {
            for (InjectableMethod injectable : this.injectableMethods) {
                if (!Modifier.isStatic(injectable.method.getModifiers()) || !preTester.test(injectable.method) || !this.methodMatches(injectable.method, flags)) continue;
                this.injectMethod(null, injectable);
            }
        }
    }

    private void injectInstanceMethods(@Nullable Object instance, @NotNull Predicate<Member> preTester, long flags) {
        if (InjectionSetting.INSTANCE_METHODS.enabled(flags)) {
            for (InjectableMethod injectable : this.injectableMethods) {
                if (Modifier.isStatic(injectable.method.getModifiers()) || !preTester.test(injectable.method) || !this.methodMatches(injectable.method, flags)) continue;
                this.injectMethod(instance, injectable);
            }
        }
    }

    private void executePostConstructListeners(@Nullable Object instance, long flags) {
        if (InjectionSetting.RUN_POST_CONSTRUCT_LISTENERS.enabled(flags)) {
            for (InjectableMethod injectable : this.postConstructMethods) {
                this.injectMethod(instance, injectable);
            }
        }
    }

    @Nullable
    private Object injectMethod(@Nullable Object instance, @NotNull InjectableMethod method) {
        try {
            boolean isStatic = Modifier.isStatic(method.method.getModifiers());
            if (!isStatic && instance == null) {
                return null;
            }
            Object[] params = this.lookupParamInstances(method);
            return method.invoke(instance, params);
        }
        catch (Throwable exception) {
            if (!method.optional) {
                throw AerogelException.forMessagedException("Unable to invoke method " + method.method, exception);
            }
            return null;
        }
    }

    private void injectField(@Nullable Object instance, @NotNull InjectableField field) {
        block4: {
            try {
                boolean isStatic = Modifier.isStatic(field.field.getModifiers());
                if (!isStatic && instance == null) {
                    return;
                }
                Element fieldElement = ElementHelper.buildElement(field.field, (Annotation[][])new Annotation[][]{field.annotations});
                Object fieldValue = this.lookupInstance(fieldElement, field.field.getType());
                if (fieldValue == null) {
                    Preconditions.checkArgument(field.optional, "Unable to resolve field value, but field " + field.field + " is required");
                    return;
                }
                field.setValue(instance, fieldValue);
            }
            catch (Throwable exception) {
                if (field.optional) break block4;
                throw AerogelException.forMessagedException("Unable to inject field value of " + field.field, exception);
            }
        }
    }

    @NotNull
    private Object[] lookupParamInstances(@NotNull InjectableMethod injectable) {
        if (injectable.method.getParameterCount() == 0) {
            return NO_PARAMS;
        }
        Object[] paramInstances = new Object[injectable.parameters.length];
        for (int i = 0; i < injectable.parameters.length; ++i) {
            Parameter parameter = injectable.parameters[i];
            Element paramElement = ElementHelper.buildElement(parameter, (Annotation[][])new Annotation[][]{injectable.parameterAnnotations[i]});
            paramInstances[i] = this.lookupInstance(paramElement, parameter.getType());
        }
        return paramInstances;
    }

    @Nullable
    private Object lookupInstance(@NotNull Element element, @NotNull Class<?> rawType) {
        if (JakartaBridge.isProvider(rawType)) {
            ContextualProvider<Object> provider = this.injector.binding(element).provider(element);
            if (JakartaBridge.needsProviderWrapping(rawType)) {
                return JakartaBridge.bridgeJakartaProvider(provider);
            }
            return provider;
        }
        return this.injector.instance(element);
    }

    private boolean methodMatches(@NotNull Method method, long flags) {
        if (Modifier.isPrivate(method.getModifiers()) && InjectionSetting.PRIVATE_METHODS.disabled(flags)) {
            return false;
        }
        if (method.getDeclaringClass().equals(this.targetClass)) {
            return true;
        }
        return InjectionSetting.INHERITED_METHODS.enabled(flags);
    }

    private boolean fieldMatches(@NotNull Field field, @Nullable Object on, long flags) {
        if (Modifier.isPrivate(field.getModifiers()) && InjectionSetting.PRIVATE_FIELDS.disabled(flags)) {
            return false;
        }
        if (!field.getDeclaringClass().equals(this.targetClass) && InjectionSetting.INHERITED_METHODS.disabled(flags)) {
            return false;
        }
        if (InjectionSetting.ONLY_UNINITIALIZED_FIELDS.enabled(flags)) {
            try {
                return ReflectionUtil.isUninitialized(field, on);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private static final class InjectableField {
        private final Field field;
        private final boolean optional;
        private final boolean onlyInjectOnce;
        private final Annotation[] annotations;
        private final MethodHandle fieldSetter;
        private final int hashCode;
        private boolean injectedOnce;

        public InjectableField(@NotNull Field field) {
            this.field = field;
            this.optional = JakartaBridge.isOptional(field);
            this.annotations = field.getDeclaredAnnotations();
            this.onlyInjectOnce = Modifier.isStatic(field.getModifiers());
            this.hashCode = this.field.hashCode() ^ Boolean.hashCode(this.optional);
            this.fieldSetter = MethodHandleUtil.toGenericSetterMethodHandle(field);
        }

        public void setValue(@Nullable Object instance, @Nullable Object value) throws Throwable {
            if (!this.onlyInjectOnce || !this.injectedOnce) {
                this.injectedOnce = true;
                if (Modifier.isStatic(this.field.getModifiers())) {
                    this.fieldSetter.invoke(value);
                } else {
                    this.fieldSetter.invoke(instance, value);
                }
            }
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class InjectableMethod
    implements Comparable<InjectableMethod> {
        private final int order;
        private final Method method;
        private final boolean optional;
        private final boolean onlyInjectOnce;
        private final Parameter[] parameters;
        private final Class<?>[] parameterTypes;
        private final Annotation[][] parameterAnnotations;
        private final MethodHandle methodHandle;
        private final int hashCode;
        private boolean injectedOnce;

        public InjectableMethod(@NotNull Method method) {
            this.method = method;
            this.optional = JakartaBridge.isOptional(method);
            this.parameters = method.getParameters();
            this.parameterTypes = method.getParameterTypes();
            this.parameterAnnotations = method.getParameterAnnotations();
            this.onlyInjectOnce = Modifier.isStatic(method.getModifiers());
            this.hashCode = this.method.hashCode() ^ Boolean.hashCode(this.optional);
            this.methodHandle = MethodHandleUtil.toGenericMethodHandle(method);
            Order orderAnnotation = method.getAnnotation(Order.class);
            this.order = orderAnnotation == null ? 0x3FFFFFFF : orderAnnotation.value();
        }

        @Nullable
        public Object invoke(@Nullable Object instance, @NotNull Object[] params) throws Throwable {
            if (!this.onlyInjectOnce || !this.injectedOnce) {
                this.injectedOnce = true;
                instance = Modifier.isStatic(this.method.getModifiers()) ? null : instance;
                return MethodHandleUtil.invokeMethod(this.methodHandle, instance, params);
            }
            return null;
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public int compareTo(@NotNull InjectableMethod o) {
            return Integer.compare(this.order, o.order);
        }
    }
}

