/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.jakarta;

import dev.derklaro.aerogel.Inject;
import dev.derklaro.aerogel.Provider;
import dev.derklaro.aerogel.Qualifier;
import dev.derklaro.aerogel.Scope;
import dev.derklaro.aerogel.util.Qualifiers;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel.internal"})
public final class JakartaBridge {
    private JakartaBridge() {
        throw new UnsupportedOperationException();
    }

    public static boolean isInjectable(@NotNull AnnotatedElement element) {
        return element.isAnnotationPresent(Inject.class) || element.isAnnotationPresent(jakarta.inject.Inject.class);
    }

    public static boolean isOptional(@NotNull AnnotatedElement element) {
        Inject inject = element.getAnnotation(Inject.class);
        return inject != null && inject.optional();
    }

    public static boolean isQualifierAnnotation(@NotNull Annotation annotation) {
        Class<? extends Annotation> type = annotation.annotationType();
        return type.isAnnotationPresent(Qualifier.class) || type.isAnnotationPresent(jakarta.inject.Qualifier.class);
    }

    public static boolean isScopeAnnotation(@NotNull Annotation annotation) {
        Class<? extends Annotation> type = annotation.annotationType();
        return type.isAnnotationPresent(Scope.class) || type.isAnnotationPresent(jakarta.inject.Scope.class);
    }

    public static void translateQualifierAnnotations(@NotNull Annotation[] annotations) {
        for (int i = 0; i < annotations.length; ++i) {
            Annotation annotation = annotations[i];
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.equals(Named.class)) continue;
            Named named = (Named)annotation;
            annotations[i] = Qualifiers.named(named.value());
        }
    }

    public static boolean isProvider(@NotNull Class<?> type) {
        return type.equals(Provider.class) || type.equals(jakarta.inject.Provider.class);
    }

    public static boolean needsProviderWrapping(@NotNull Class<?> type) {
        return type.equals(jakarta.inject.Provider.class);
    }

    @NotNull
    public static <T> jakarta.inject.Provider<T> bridgeJakartaProvider(@NotNull Provider<T> provider) {
        return provider::get;
    }
}

