/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.invoke;

import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.InjectionContext;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.Provider;
import dev.derklaro.aerogel.internal.invoke.ParameterValueGetter;
import dev.derklaro.aerogel.internal.jakarta.JakartaBridge;
import dev.derklaro.aerogel.internal.util.ElementHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.*"})
public final class ParameterHelper {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final ParameterValueGetter EMPTY_SUPPLIER = (__, ____) -> EMPTY_OBJECT_ARRAY;

    private ParameterHelper() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static ParameterValueGetter constructParameterSuppliers(@NotNull Parameter[] parameters) {
        if (parameters.length == 0) {
            return EMPTY_SUPPLIER;
        }
        ParameterResolver[] resolvers = new ParameterResolver[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            ParameterResolver resolver;
            Parameter parameter = parameters[i];
            Element element = ElementHelper.buildElement(parameter, (Annotation[][])new Annotation[][]{parameter.getDeclaredAnnotations()});
            if (JakartaBridge.isProvider(parameter.getType())) {
                resolver = (injector, context) -> context.resolveProvider(element);
                if (JakartaBridge.needsProviderWrapping(parameter.getType())) {
                    resolver = resolver.then(provider -> JakartaBridge.bridgeJakartaProvider((Provider)provider));
                }
            } else {
                resolver = (injector, context) -> {
                    ContextualProvider<?> parameterProvider = context.resolveProvider(element);
                    InjectionContext parameterContext = context.enterSubcontext(parameter.getParameterizedType(), parameterProvider, element);
                    return parameterContext.resolveInstance();
                };
            }
            resolvers[i] = resolver;
        }
        return (context, injector) -> {
            Object[] values = new Object[resolvers.length];
            for (int i = 0; i < resolvers.length; ++i) {
                Object value;
                values[i] = value = resolvers[i].resolveInstance(injector, context);
            }
            return values;
        };
    }

    @FunctionalInterface
    private static interface ParameterResolver {
        @Nullable
        public Object resolveInstance(@NotNull Injector var1, @NotNull InjectionContext var2);

        @NotNull
        default public ParameterResolver then(@NotNull UnaryOperator<Object> downstream) {
            return (injector, context) -> {
                Object ourValue = this.resolveInstance(injector, context);
                return downstream.apply(ourValue);
            };
        }
    }
}

