/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.context.util;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.InjectionContext;
import dev.derklaro.aerogel.binding.BindingHolder;
import dev.derklaro.aerogel.internal.PassthroughException;
import dev.derklaro.aerogel.internal.context.DefaultInjectionContext;
import dev.derklaro.aerogel.internal.context.InjectionContextProvider;
import java.lang.reflect.Type;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.*"})
public final class ContextInstanceResolveHelper {
    private ContextInstanceResolveHelper() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static Object resolveInstance(@NotNull Element element, @NotNull BindingHolder bindingHolder) {
        return ContextInstanceResolveHelper.resolveInstance(element.componentType(), bindingHolder.provider(element));
    }

    @Nullable
    public static Object resolveInstance(@NotNull Type requestedType, @NotNull ContextualProvider<?> provider) {
        DefaultInjectionContext context = InjectionContextProvider.enterRootContext(provider, requestedType);
        return ContextInstanceResolveHelper.resolveInstanceAndRemoveContext(context);
    }

    @Nullable
    public static Object resolveInstanceAndRemoveContext(@NotNull InjectionContext context) {
        try {
            Object result = context.resolveInstance();
            if (context.rootContext()) {
                context.finishConstruction();
            }
            return result;
        }
        catch (Exception exception) {
            if (context.rootContext()) {
                InjectionContextProvider.removeRootContext(context);
            }
            PassthroughException.rethrow(exception);
            throw AerogelException.forException(exception);
        }
    }
}

